/*
 * Decompiled with CFR 0.152.
 */
package org.aec.facade;

import java.awt.Color;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.aec.facade.Building;
import org.aec.facade.FileHandler;
import org.aec.facade.FrameBuffer;
import org.aec.facade.Side;

public class AECPlugin {
    private static FrameBuffer frame = new FrameBuffer();
    private static Building building = new Building();
    private FileHandler fw = new FileHandler();
    public int scale = 8;
    protected int frameWidth = 100;
    protected Side activeSide = null;
    protected boolean allSides = false;
    protected Color activeColor = new Color(255, 255, 255, 200);
    protected Color inactiveColor = new Color(255, 255, 255, 80);

    public AECPlugin() {
        frame.setColor(Color.black);
        frame.flush();
    }

    public void init() {
        System.out.println("INIT...");
        for (Side side : building.getSides()) {
            side.setColor(this.inactiveColor);
        }
    }

    public void setActiveColor(Color c) {
        this.activeColor = c;
    }

    public void setInActiveColor(Color c) {
        this.inactiveColor = c;
    }

    public void setFrameWidth(int fw) {
        this.frameWidth = fw;
    }

    public void loadConfig() {
        System.out.println("LOADING...");
        String[] fileTextArray = this.fw.load();
        if (fileTextArray == null) {
            return;
        }
        int i = 0;
        while (i < fileTextArray.length) {
            int index;
            String temp = fileTextArray[i];
            if (temp.contains("Scale")) {
                index = temp.indexOf("#");
                temp = temp.substring(index + 1, temp.length());
                this.scale = Integer.parseInt(temp);
            } else if (temp.contains("Port")) {
                index = temp.indexOf("#");
                temp = temp.substring(index + 1, temp.length());
                frame.setPort(Integer.parseInt(temp));
            } else if (temp.contains("Ip")) {
                index = temp.indexOf("#");
                temp = temp.substring(index + 1, temp.length());
                try {
                    InetAddress adr = InetAddress.getByName(temp);
                    frame.setIp(adr);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            } else {
                index = temp.indexOf("#");
                String tempRest = temp.substring(index + 1, temp.length());
                temp = temp.substring(0, index);
                index = tempRest.indexOf("#");
                int x = Integer.parseInt(tempRest.substring(0, index));
                int y = Integer.parseInt(tempRest.substring(index + 1, tempRest.length()));
                this.setSideOffset(temp, x, y);
            }
            ++i;
        }
        System.out.println("LOADING COMPLETED");
    }

    public void saveConfig() {
        String saveText = new String();
        saveText = String.valueOf(saveText) + "Scale#" + this.scale + "\n";
        saveText = String.valueOf(saveText) + "Port#" + frame.getPort() + "\n";
        saveText = String.valueOf(saveText) + "Ip#" + frame.getIp() + "\n";
        for (Side side : building.getSides()) {
            String name = side.getName();
            name = name.toUpperCase();
            name = name.replace(" ", "_");
            saveText = String.valueOf(saveText) + name + "#" + side.x + "#" + side.y + "\n";
        }
        this.fw.save(saveText);
    }

    public void keyPressed(int value, int keyCode) {
        if (value == 115 || value == 83) {
            System.out.println("----SAVED CHANGES----");
            this.saveConfig();
            return;
        }
        if (value == 82) {
            if (this.scale < 20) {
                ++this.scale;
            }
            System.out.println("CHANGED SCALE TO " + this.scale);
        }
        if (value == 114) {
            if (this.scale > 1) {
                --this.scale;
            }
            System.out.println("CHANGED SCALE TO " + this.scale);
            return;
        }
        if (value >= 48 && value <= 57) {
            this.changeSide(value);
            return;
        }
        if (this.activeSide != null) {
            switch (keyCode) {
                case 38: {
                    this.activeSide.moveUp();
                    break;
                }
                case 37: {
                    this.activeSide.moveLeft();
                    break;
                }
                case 39: {
                    this.activeSide.moveRight();
                    break;
                }
                case 40: {
                    this.activeSide.moveDown();
                }
            }
        }
        if (this.allSides) {
            switch (keyCode) {
                default: {
                    break;
                }
                case 38: {
                    for (Side side : building.getSides()) {
                        side.moveUp();
                    }
                    break;
                }
                case 37: {
                    for (Side side : building.getSides()) {
                        side.moveLeft();
                    }
                    break;
                }
                case 39: {
                    for (Side side : building.getSides()) {
                        side.moveRight();
                    }
                    break;
                }
                case 40: {
                    for (Side side : building.getSides()) {
                        side.moveDown();
                    }
                }
            }
        }
    }

    void changeSide(int value) {
        if (this.activeSide != null) {
            this.activeSide.setColor(this.inactiveColor);
        }
        if (this.allSides) {
            for (Side side : building.getSides()) {
                side.setColor(this.inactiveColor);
            }
        }
        this.activeSide = null;
        this.allSides = false;
        if (value == 48) {
            System.out.println("NO SELECTION");
            return;
        }
        if (value == 57) {
            this.allSides = true;
            for (Side side : building.getSides()) {
                side.setColor(this.activeColor);
            }
            System.out.println("ALL SELECTED");
            return;
        }
        int side = value - 48 - 1;
        this.activeSide = this.getSide(Building.SIDE.values()[side]);
        System.out.println("CHANGED ACTIVE SIDE TO " + this.activeSide.name);
        this.activeSide.setColor(this.activeColor);
    }

    public void setSideOffset(String side, int x, int y) {
        Building.SIDE s = Building.SIDE.valueOf(side);
        building.getSide(s).setOffset(x, y);
    }

    public Side getSide(String side) {
        Building.SIDE s = Building.SIDE.valueOf(side);
        return building.getSide(s);
    }

    public Side getSide(Building.SIDE side) {
        return building.getSide(side);
    }

    public List getSides() {
        return building.getSides();
    }

    public void update(int[] pixels) {
        for (Side side : building.getSides()) {
            side.update(frame, pixels, this.scale, this.frameWidth);
        }
        frame.flush();
    }
}

