/*
 * Decompiled with CFR 0.152.
 */
package org.aec.facade;

import java.awt.Color;
import org.aec.facade.FrameBuffer;

public abstract class Side {
    protected String name;
    protected int startAddr;
    protected int endAddr;
    protected int startRow;
    protected int endRow;
    protected int nrColumns;
    protected int[][] windowAddrs;
    protected int x = 0;
    protected int y = 0;
    protected Color color = new Color(100, 100, 100);
    protected int pixelWidth = 1;
    protected int pixelHeight = 1;

    public String getName() {
        return this.name;
    }

    public void setOffset(int x_, int y_) {
        this.x = x_;
        this.y = y_;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color_) {
        this.color = color_;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public int[][] getWindowAddress() {
        return this.windowAddrs;
    }

    public int[] getOffset() {
        int[] out = new int[]{this.x, this.y};
        return out;
    }

    public int getStartAddress() {
        return this.startAddr;
    }

    public int getEndAddress() {
        return this.endAddr;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getNrColumns() {
        return this.nrColumns;
    }

    public int getAddress(int row, int column) {
        if (row >= this.startRow && row <= this.endRow && column >= 0 && column < this.nrColumns) {
            return this.windowAddrs[row - this.startRow][column];
        }
        return -1;
    }

    public void setColor(FrameBuffer frame, Color color) {
        int address = this.getStartAddress();
        while (address <= this.getEndAddress()) {
            frame.setColor(address, color);
            ++address;
        }
    }

    public void setRowColor(FrameBuffer frame, int row, Color color) {
        if (row >= this.getStartRow() && row <= this.getEndRow()) {
            int column = 0;
            while (column < this.getNrColumns()) {
                frame.setColor(this.getAddress(row, column), color);
                ++column;
            }
        }
    }

    public void setColumnColor(FrameBuffer frame, int column, Color color) {
        if (column >= 0 && column < this.getNrColumns()) {
            int row = this.getStartRow();
            while (row <= this.getEndRow()) {
                frame.setColor(this.getAddress(row, column), color);
                ++row;
            }
        }
    }

    public void setWindowColor(FrameBuffer frame, int row, int column, Color color) {
        frame.setColor(this.getAddress(row, column), color);
    }

    public void update(FrameBuffer frame, int[] pixels, int scale, int width) {
        int j = 0;
        while (j < this.windowAddrs.length) {
            int i = 0;
            while (i < this.windowAddrs[j].length) {
                int pos;
                if (this.windowAddrs[j][i] > -1 && (pos = (this.x + i * this.pixelWidth) * scale + (this.y + j * this.pixelHeight) * scale * width) < pixels.length) {
                    int value = pixels[pos];
                    Color color = new Color(value);
                    frame.setColor(this.getAddress(this.getStartRow() + j, i), color);
                }
                ++i;
            }
            ++j;
        }
    }

    public void moveUp() {
        if (this.y <= 0) {
            return;
        }
        --this.y;
    }

    public void moveDown() {
        ++this.y;
    }

    public void moveLeft() {
        if (this.x <= 0) {
            return;
        }
        this.x -= 2;
    }

    public void moveRight() {
        this.x += 2;
    }
}

