/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.aec.facade.AECPlugin;
import org.aec.facade.Building;
import org.aec.facade.Side;
import processing.core.PApplet;
import processing.core.PFont;
import processing.data.StringList;
import processing.data.Table;
import processing.data.TableRow;

public class AEC_SimpleRect_Player_24_GPT
extends PApplet {
    AEC aec;
    int[][] paintgrid;
    int x;
    int y;
    int _frame;
    int aniFramerate;
    int playbackIterator;
    boolean starting;
    ArrayList<frame> animation = new ArrayList();
    Table pixelTable;
    long triggerframetime;
    StringList filenames;
    int numberOfFiles = 0;
    int playCount = 0;
    int maxPlays = 3;

    public void setup() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                AEC_SimpleRect_Player_24_GPT.println((String)("Uncaught exception in thread '" + t.getName() + "': " + e));
                e.printStackTrace();
                AEC_SimpleRect_Player_24_GPT.println((String)"An error occurred. Moving to the next animation.");
                AEC_SimpleRect_Player_24_GPT.this.nextAnimation();
            }
        });
        this.frameRate(50.0f);
        PFont myFont = this.createFont("Arial", 24.0f);
        this.textFont(myFont);
        this.aec = new AEC();
        this.aec.init();
        this.filenames = new StringList();
        File sketchFolder = new File(this.sketchPath());
        File animationFolder = new File(sketchFolder, "animations");
        AEC_SimpleRect_Player_24_GPT.println((String)("Animations folder path: " + animationFolder.getAbsolutePath()));
        if (animationFolder.exists() && animationFolder.isDirectory()) {
            this.findCSVFiles(animationFolder);
        } else {
            AEC_SimpleRect_Player_24_GPT.println((String)"Animations folder does not exist or could not be read.");
            try {
                if (animationFolder.mkdir()) {
                    AEC_SimpleRect_Player_24_GPT.println((String)("Animations folder created at: " + animationFolder.getAbsolutePath()));
                } else {
                    AEC_SimpleRect_Player_24_GPT.println((String)"Failed to create animations folder.");
                }
            }
            catch (SecurityException se) {
                AEC_SimpleRect_Player_24_GPT.println((String)"SecurityException: Unable to create animations folder due to insufficient permissions.");
                se.printStackTrace();
                this.filenames.clear();
            }
        }
        this.filenames = this.removeDuplicates(this.filenames);
        this.filenames.sort();
        AEC_SimpleRect_Player_24_GPT.println((String)("Total number of .csv files found: " + this.filenames.size()));
        AEC_SimpleRect_Player_24_GPT.println((String)"Files found:");
        for (String filename : this.filenames) {
            AEC_SimpleRect_Player_24_GPT.println((String)filename);
        }
        this.numberOfFiles = this.filenames.size();
        if (this.filenames.size() == 0) {
            AEC_SimpleRect_Player_24_GPT.println((String)"No .csv files found in the animations folder.");
        } else {
            AEC_SimpleRect_Player_24_GPT.println((String)("Found " + this.filenames.size() + " .csv files."));
        }
        this.starting = true;
        this.aniFramerate = 1000;
        this.triggerframetime = 0L;
        this.playbackIterator = 0;
        this._frame = 0;
    }

    public void findCSVFiles(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.findCSVFiles(file);
                } else if (file.isFile() && file.getName().toLowerCase().endsWith(".csv")) {
                    if (file.canRead()) {
                        if (!file.isHidden() && !file.getName().equalsIgnoreCase("Thumbs.db")) {
                            try {
                                String filePath = file.getAbsolutePath();
                                this.filenames.append(filePath);
                                AEC_SimpleRect_Player_24_GPT.println((String)("Added file: " + filePath));
                            }
                            catch (Exception e) {
                                AEC_SimpleRect_Player_24_GPT.println((String)("Error handling file: " + file.getAbsolutePath()));
                                e.printStackTrace();
                            }
                        }
                    } else {
                        AEC_SimpleRect_Player_24_GPT.println((String)("Cannot read file: " + file.getAbsolutePath()));
                    }
                }
                ++n2;
            }
        } else {
            AEC_SimpleRect_Player_24_GPT.println((String)("Error reading folder: " + folder.getAbsolutePath()));
        }
    }

    public StringList removeDuplicates(StringList list) {
        StringList uniqueList = new StringList();
        for (String item : list) {
            if (!uniqueList.hasValue(item)) {
                uniqueList.append(item);
                continue;
            }
            AEC_SimpleRect_Player_24_GPT.println((String)("Duplicate file detected and removed: " + item));
        }
        return uniqueList;
    }

    public void draw() {
        this.background(0);
        try {
            int i;
            this.aec.beginDraw();
            this.noStroke();
            if (this.filenames.size() == 0) {
                AEC_SimpleRect_Player_24_GPT.println((String)"No animations to play.");
                return;
            }
            if (this.starting) {
                this.x = this.width / this.aec.getScaleX();
                this.y = this.height / this.aec.getScaleY();
                this.paintgrid = new int[this.x][this.y];
                i = 0;
                while (i < this.x) {
                    int j = 0;
                    while (j < this.y) {
                        this.paintgrid[i][j] = this.color(0, 0, 0, 0);
                        ++j;
                    }
                    ++i;
                }
                this.starting = false;
            }
            if (this.triggerframetime < (long)this.millis()) {
                this.triggerframetime = this.millis() + this.aniFramerate;
                if (this.animation.size() == 0) {
                    if (this.filenames.size() > 0) {
                        this.importFromFile();
                    } else {
                        AEC_SimpleRect_Player_24_GPT.println((String)"No filenames available for import.");
                        return;
                    }
                }
                if (this.animation.size() == 0) {
                    AEC_SimpleRect_Player_24_GPT.println((String)"No frames in the current animation. Skipping to next animation.");
                    this.nextAnimation();
                    return;
                }
                this.resetFrame();
                AEC_SimpleRect_Player_24_GPT.print((String)".");
                int lastFrameIndex = this.animation.size() - 1;
                if (this._frame < 0 || this._frame > lastFrameIndex) {
                    AEC_SimpleRect_Player_24_GPT.println((String)("Frame index out of bounds: " + this._frame));
                    this._frame = 0;
                    return;
                }
                frame f = this.animation.get(this._frame);
                this.paintgrid = this.myClone(f._framepaintgrid);
                ++this._frame;
                if (this._frame > lastFrameIndex) {
                    this._frame = 0;
                    ++this.playCount;
                    if (this.playCount >= this.maxPlays) {
                        this.playCount = 0;
                        this.nextAnimation();
                    }
                }
            }
            i = 0;
            while (i < this.x) {
                int j = 0;
                while (j < this.y) {
                    this.fill(this.paintgrid[i][j]);
                    this.rect(i, j, 1.0f, 1.0f);
                    ++j;
                }
                ++i;
            }
            this.aec.endDraw();
            this.aec.drawSides();
            this.resetMatrix();
            this.fill(255);
            this.textSize(12.0f);
            String fileInfo = "Total files: " + this.numberOfFiles;
            float txtWidth = this.textWidth(fileInfo);
            float xPosition = AEC_SimpleRect_Player_24_GPT.max((float)((float)this.width - txtWidth - 10.0f), (float)0.0f);
            float yPosition = AEC_SimpleRect_Player_24_GPT.max((int)(this.height - 10), (int)0);
            this.text(fileInfo, xPosition, yPosition);
        }
        catch (Exception e) {
            AEC_SimpleRect_Player_24_GPT.println((String)("Exception in draw(): " + e.getMessage()));
            e.printStackTrace();
            this.nextAnimation();
        }
    }

    public void nextAnimation() {
        ++this.playbackIterator;
        if (this.playbackIterator >= this.filenames.size()) {
            this.playbackIterator = 0;
        }
        this.animation.clear();
        this._frame = 0;
        this.triggerframetime = this.millis();
        this.printNewAnimation();
    }

    public void printNewAnimation() {
        if (this.playbackIterator >= 0 && this.playbackIterator < this.filenames.size()) {
            String animationName = this.filenames.get(this.playbackIterator);
            AEC_SimpleRect_Player_24_GPT.println((String)("\nNow playing animation: " + animationName));
        } else {
            AEC_SimpleRect_Player_24_GPT.println((String)"Playback iterator out of bounds.");
        }
    }

    public void importFromFile() {
        block23: {
            this.resetFrame();
            this.resetAnimation();
            if (this.playbackIterator >= 0 && this.playbackIterator < this.filenames.size()) {
                String fileInfo = this.filenames.get(this.playbackIterator);
                int fileframerate = 25;
                try {
                    String filename = new File(fileInfo).getName();
                    int lastSpaceIndex = filename.lastIndexOf(32);
                    int dotIndex = filename.lastIndexOf(46);
                    if (lastSpaceIndex != -1 && dotIndex > lastSpaceIndex) {
                        String framerateString = filename.substring(lastSpaceIndex + 1, dotIndex);
                        fileframerate = Integer.parseInt(framerateString);
                        if (fileframerate <= 0) {
                            AEC_SimpleRect_Player_24_GPT.println((String)("Invalid framerate extracted (" + fileframerate + "). Using default 25 fps."));
                            fileframerate = 25;
                        }
                    } else {
                        AEC_SimpleRect_Player_24_GPT.println((String)"No valid framerate found in filename. Using default 25 fps.");
                        fileframerate = 25;
                    }
                    AEC_SimpleRect_Player_24_GPT.println((String)("Extracted framerate: " + fileframerate));
                    this.aniFramerate = fileframerate > 0 ? AEC_SimpleRect_Player_24_GPT.round((float)(1000.0f / (float)fileframerate)) : 40;
                }
                catch (Exception e) {
                    AEC_SimpleRect_Player_24_GPT.println((String)"Error parsing framerate from filename. Using default 25 fps.");
                    e.printStackTrace();
                    fileframerate = 25;
                    this.aniFramerate = 40;
                }
                File csvFile = new File(fileInfo);
                if (csvFile.exists()) {
                    try {
                        this.pixelTable = this.loadTable(csvFile.getAbsolutePath(), "header,csv");
                        if (this.pixelTable != null) {
                            int frmcnt = -1;
                            int[][] tmpgrid = new int[this.x][this.y];
                            int i = 0;
                            while (i < this.x) {
                                int j = 0;
                                while (j < this.y) {
                                    tmpgrid[i][j] = this.color(0, 0, 0, 0);
                                    ++j;
                                }
                                ++i;
                            }
                            int _f = -1;
                            for (TableRow newPixelRow : this.pixelTable.rows()) {
                                int newF;
                                try {
                                    newF = newPixelRow.getInt("f");
                                }
                                catch (Exception exception) {
                                    AEC_SimpleRect_Player_24_GPT.println((String)"Invalid frame number in CSV. Skipping row.");
                                    continue;
                                }
                                if (_f != newF) {
                                    if (_f != -1) {
                                        this.animation.add(new frame(frmcnt, this.myClone(tmpgrid)));
                                    }
                                    ++frmcnt;
                                    _f = newF;
                                }
                                int _x = newPixelRow.getInt("x");
                                int _y = newPixelRow.getInt("y");
                                int r = newPixelRow.getInt("r");
                                int g = newPixelRow.getInt("g");
                                int b = newPixelRow.getInt("b");
                                int a = newPixelRow.getInt("a");
                                int _c = this.color(r, g, b, a);
                                if (_x >= 0 && _x < this.x && _y >= 0 && _y < this.y) {
                                    tmpgrid[_x][_y] = _c;
                                    continue;
                                }
                                AEC_SimpleRect_Player_24_GPT.println((String)("Warning: Pixel coordinates out of bounds (" + _x + ", " + _y + "). Skipping pixel."));
                            }
                            if (_f != -1) {
                                this.animation.add(new frame(frmcnt, this.myClone(tmpgrid)));
                            }
                            if (this.animation.size() == 0) {
                                AEC_SimpleRect_Player_24_GPT.println((String)"No valid frames found in the CSV file. Moving to next animation.");
                                this.nextAnimation();
                            } else {
                                AEC_SimpleRect_Player_24_GPT.println((String)("Imported " + this.animation.size() + " frames."));
                            }
                            break block23;
                        }
                        AEC_SimpleRect_Player_24_GPT.println((String)"Failed to load table from file. Moving to next animation.");
                        this.nextAnimation();
                    }
                    catch (Exception e) {
                        AEC_SimpleRect_Player_24_GPT.println((String)("Exception occurred while loading animation: " + e.getMessage()));
                        e.printStackTrace();
                        this.nextAnimation();
                    }
                } else {
                    AEC_SimpleRect_Player_24_GPT.println((String)"No .csv file found in the specified path. Moving to next animation.");
                    this.nextAnimation();
                }
            } else {
                AEC_SimpleRect_Player_24_GPT.println((String)"Playback iterator out of bounds. Moving to next animation.");
                this.nextAnimation();
            }
        }
    }

    public void resetFrame() {
        if (this.paintgrid != null) {
            int i = 0;
            while (i < this.x) {
                int j = 0;
                while (j < this.y) {
                    this.paintgrid[i][j] = this.color(0, 0, 0, 0);
                    ++j;
                }
                ++i;
            }
        } else {
            AEC_SimpleRect_Player_24_GPT.println((String)"paintgrid is null during resetFrame().");
        }
    }

    public void resetAnimation() {
        this.animation.clear();
    }

    public int[][] myClone(int[][] from) {
        int[][] returnArr = new int[this.x][this.y];
        int i = 0;
        while (i < this.x) {
            int j = 0;
            while (j < this.y) {
                returnArr[i][j] = from[i][j];
                ++j;
            }
            ++i;
        }
        return returnArr;
    }

    public void settings() {
        this.size(1200, 450);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AEC_SimpleRect_Player_24_GPT"};
        if (passedArgs != null) {
            PApplet.main((String[])AEC_SimpleRect_Player_24_GPT.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AEC {
        AECPlugin plugin = new AECPlugin();
        HouseDrawer house;

        public AEC() {
            this.house = new HouseDrawer(this.plugin);
        }

        public void init() {
            this.plugin.setFrameWidth(AEC_SimpleRect_Player_24_GPT.this.width);
            this.plugin.init();
            this.loadConfig();
        }

        public void loadConfig() {
            this.plugin.loadConfig();
        }

        public void beginDraw() {
            AEC_SimpleRect_Player_24_GPT.this.scale(2 * this.plugin.scale, this.plugin.scale);
        }

        public void endDraw() {
            AEC_SimpleRect_Player_24_GPT.this.resetMatrix();
            AEC_SimpleRect_Player_24_GPT.this.loadPixels();
            this.plugin.update(AEC_SimpleRect_Player_24_GPT.this.pixels);
        }

        public void drawSides() {
            this.house.draw();
        }

        public void keyPressed(int value) {
            this.plugin.keyPressed(value, AEC_SimpleRect_Player_24_GPT.this.keyCode);
            if (value == 105) {
                this.house.toggleIds();
            }
        }

        public void setActiveColor(Color c) {
            this.plugin.setActiveColor(c);
        }

        public void setInActiveColor(Color c) {
            this.plugin.setInActiveColor(c);
        }

        public int getScaleX() {
            return 2 * this.plugin.scale;
        }

        public int getScaleY() {
            return this.plugin.scale;
        }
    }

    class HouseDrawer {
        AECPlugin aec;
        int size = 10;
        PFont font;
        boolean showIds = false;

        public HouseDrawer(AECPlugin aec_) {
            this.aec = aec_;
            this.font = AEC_SimpleRect_Player_24_GPT.this.loadFont("LucidaConsole-8.vlw");
        }

        public void toggleIds() {
            this.showIds = !this.showIds;
        }

        public void draw() {
            AEC_SimpleRect_Player_24_GPT.this.resetMatrix();
            int i = 0;
            while (i < Building.SIDE.values().length) {
                Building.SIDE sideEnum = Building.SIDE.values()[i];
                Side side = this.aec.getSide(sideEnum);
                AEC_SimpleRect_Player_24_GPT.this.stroke(side.getColor().getRed(), side.getColor().getGreen(), side.getColor().getBlue(), side.getColor().getAlpha());
                AEC_SimpleRect_Player_24_GPT.this.noFill();
                this.drawSide(side);
                ++i;
            }
        }

        public void drawSide(Side s) {
            int[][] adr = s.getWindowAddress();
            int pWidth = s.getPixelWidth();
            int pHeight = s.getPixelHeight();
            int y = 0;
            while (y < adr.length) {
                int x = 0;
                while (x < adr[y].length) {
                    if (adr[y][x] > -1) {
                        int fx = (s.getX() + x * pWidth) * this.aec.scale;
                        int fy = (s.getY() + y * pHeight) * this.aec.scale;
                        AEC_SimpleRect_Player_24_GPT.this.rect(fx, fy, pWidth * this.aec.scale, pHeight * this.aec.scale);
                        if (this.showIds) {
                            AEC_SimpleRect_Player_24_GPT.this.textFont(this.font, 8.0f);
                            AEC_SimpleRect_Player_24_GPT.this.text("" + adr[y][x], fx + pWidth * this.aec.scale / 4, (float)fy + (float)(pHeight * this.aec.scale) * 0.9f);
                        }
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    class frame {
        int _f;
        int[][] _framepaintgrid;

        public frame() {
        }

        public frame(int f, int[][] framepaintgrid) {
            this._f = f;
            this._framepaintgrid = framepaintgrid;
        }
    }
}

