/* autogenerated by Processing revision 1293 on 2024-09-18 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import java.io.File;
import java.util.ArrayList;
import processing.data.*;
import java.awt.Color;
import org.aec.facade.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class AEC_SimpleRect_Player_24_GPT extends PApplet {

 //<>//



AEC aec;

int[][] paintgrid;
int x, y, _frame, aniFramerate, playbackIterator;
boolean starting;
ArrayList<frame> animation = new ArrayList<frame>();
Table pixelTable;
long triggerframetime;
StringList filenames;

// Add a variable to display the number of files
int numberOfFiles = 0;

public void setup() {
  // Set up a global exception handler to catch any uncaught exceptions
  Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
    public void uncaughtException(Thread t, Throwable e) {
      println("Uncaught exception in thread '" + t.getName() + "': " + e);
      e.printStackTrace();
      // Instead of exiting, move to the next animation
      println("An error occurred. Moving to the next animation.");
      nextAnimation();
    }
  });

  frameRate(50);
  /* size commented out by preprocessor */;
  PFont myFont = createFont("Arial", 24);
  textFont(myFont);

  aec = new AEC();
  aec.init();

  filenames = new StringList();

  // Use platform-independent way to get the animations folder path
  File sketchFolder = new File(sketchPath());
  File animationFolder = new File(sketchFolder, "animations");
  println("Animations folder path: " + animationFolder.getAbsolutePath());

  if (animationFolder.exists() && animationFolder.isDirectory()) {
    findCSVFiles(animationFolder);
  } else {
    println("Animations folder does not exist or could not be read.");
    // Optionally create the directory
    try {
      if (animationFolder.mkdir()) {
        println("Animations folder created at: " + animationFolder.getAbsolutePath());
      } else {
        println("Failed to create animations folder.");
      }
    } catch (SecurityException se) {
      println("SecurityException: Unable to create animations folder due to insufficient permissions.");
      se.printStackTrace();
      filenames.clear(); // Ensure filenames list is empty
    }
  }

  // Remove duplicates from the filenames list
  filenames = removeDuplicates(filenames);

  // Sort the filenames
  filenames.sort();

  // **Print the number of files and their names to the console**
  println("Total number of .csv files found: " + filenames.size());
  println("Files found:");
  for (String filename : filenames) {
    println(filename);
  }

  // Set the number of files for display in the window
  numberOfFiles = filenames.size();

  if (filenames.size() == 0) {
    println("No .csv files found in the animations folder.");
    // Continue running, but perhaps display a message or handle accordingly
  } else {
    println("Found " + filenames.size() + " .csv files.");
  }

  starting = true;

  aniFramerate = 1000;
  triggerframetime = 0;
  playbackIterator = 0;

  _frame = 0;
}

public void findCSVFiles(File folder) {
  File[] files = folder.listFiles();
  if (files != null) {
    for (File file : files) {
      if (file.isDirectory()) {
        // Recursively look into subdirectories
        findCSVFiles(file);
      } else if (file.isFile() && file.getName().toLowerCase().endsWith(".csv")) {
        if (file.canRead()) {
          // Skip hidden files and common Windows system files
          if (file.isHidden() || file.getName().equalsIgnoreCase("Thumbs.db")) {
            continue; // Skip this file
          }
          try {
            String filePath = file.getAbsolutePath();
            filenames.append(filePath);
            println("Added file: " + filePath);
          } catch (Exception e) {
            println("Error handling file: " + file.getAbsolutePath());
            e.printStackTrace();
          }
        } else {
          println("Cannot read file: " + file.getAbsolutePath());
        }
      }
    }
  } else {
    println("Error reading folder: " + folder.getAbsolutePath());
  }
}

// Function to remove duplicates from the filenames list
public StringList removeDuplicates(StringList list) {
  StringList uniqueList = new StringList();
  for (String item : list) {
    if (!uniqueList.hasValue(item)) {
      uniqueList.append(item);
    } else {
      println("Duplicate file detected and removed: " + item);
    }
  }
  return uniqueList;
}

int playCount = 0; // Counter to track how many times the current animation has been played
int maxPlays = 3;  // Maximum number of times to play each animation before switching

public void draw() {
  background(0); // Clear the background to black

  try {
    aec.beginDraw();

    noStroke();

    // Even if filenames list is empty, continue running
    if (filenames.size() == 0) {
      println("No animations to play.");
      return;
    }

    if (starting) {
      x = width / aec.getScaleX();
      y = height / aec.getScaleY();

      // Initialize paintgrid with correct dimensions
      paintgrid = new int[x][y];

      for (int i = 0; i < x; i++) {
        for (int j = 0; j < y; j++) {
          paintgrid[i][j] = color(0, 0, 0, 0);
        }
      }
      starting = false;
    }

    if (triggerframetime < millis()) {
      triggerframetime = millis() + aniFramerate;

      // If there are no frames in the animation, load from the file
      if (animation.size() == 0) {
        if (filenames.size() > 0) {
          importFromFile(); // Ensure there are filenames to load from
        } else {
          println("No filenames available for import.");
          return;
        }
      }

      if (animation.size() == 0) {
        println("No frames in the current animation. Skipping to next animation.");
        nextAnimation();
        return;
      }

      resetFrame();

      // Print a dot without a line break
      print(".");

      int lastFrameIndex = animation.size() - 1;

      if (_frame >= 0 && _frame <= lastFrameIndex) {
        frame f = animation.get(_frame);
        paintgrid = myClone(f._framepaintgrid);
      } else {
        println("Frame index out of bounds: " + _frame);
        _frame = 0;
        return;
      }

      _frame++;

      // If the animation has reached its end
      if (_frame > lastFrameIndex) {
        _frame = 0;
        playCount++;

        // Check if the animation has been played maxPlays times
        if (playCount >= maxPlays) {
          playCount = 0; // Reset the play count
          nextAnimation();
        }
      }
    }

    // Drawing the paintgrid onto the canvas
    for (int i = 0; i < x; i++) {
      for (int j = 0; j < y; j++) {
        fill(paintgrid[i][j]);
        rect(i, j, 1, 1);
      }
    }

    aec.endDraw();
    aec.drawSides();

    // Reset transformations
    resetMatrix();

    // Display the number of files at the bottom right AFTER aec.endDraw()
    fill(255); // White color for text
    textSize(12);
    String fileInfo = "Total files: " + numberOfFiles;
    float txtWidth = textWidth(fileInfo);
    float xPosition = max(width - txtWidth - 10, 0);
    float yPosition = max(height - 10, 0);

    text(fileInfo, xPosition, yPosition);

  } catch (Exception e) {
    println("Exception in draw(): " + e.getMessage());
    e.printStackTrace();
    // Handle the exception and move to the next animation
    nextAnimation();
  }
}

public void nextAnimation() {
  // Move to the next animation
  playbackIterator++;

  // If playbackIterator exceeds the available filenames, reset it to loop through animations
  if (playbackIterator >= filenames.size()) {
    playbackIterator = 0; // Reset to the first animation
  }

  // Clear the animation and load the next one
  animation.clear();
  _frame = 0;
  triggerframetime = millis(); // Reset the trigger time

  printNewAnimation(); // Print the name of the new animation file
}

public void printNewAnimation() {
  if (playbackIterator >= 0 && playbackIterator < filenames.size()) {
    String animationName = filenames.get(playbackIterator);
    println("\nNow playing animation: " + animationName);
  } else {
    println("Playback iterator out of bounds.");
  }
}

public void importFromFile() {
  resetFrame();
  resetAnimation();

  // Ensure playbackIterator is within bounds
  if (playbackIterator >= 0 && playbackIterator < filenames.size()) {
    // Get the filename of the animation (including path)
    String fileInfo = filenames.get(playbackIterator);

    // Default framerate if extraction fails
    int fileframerate = 25;

    // Attempt to extract framerate from filename
    try {
      String filename = new File(fileInfo).getName(); // Get the filename without path

      int lastSpaceIndex = filename.lastIndexOf(' ');
      int dotIndex = filename.lastIndexOf('.');

      if (lastSpaceIndex != -1 && dotIndex > lastSpaceIndex) {
        String framerateString = filename.substring(lastSpaceIndex + 1, dotIndex); // Get the number before the .csv
        fileframerate = Integer.parseInt(framerateString); // Parse framerate
        if (fileframerate <= 0) {
          println("Invalid framerate extracted (" + fileframerate + "). Using default 25 fps.");
          fileframerate = 25;
        }
      } else {
        println("No valid framerate found in filename. Using default 25 fps.");
        fileframerate = 25;
      }

      println("Extracted framerate: " + fileframerate);

      // Calculate aniFramerate safely
      aniFramerate = (fileframerate > 0) ? round(1000.0f / fileframerate) : 40; // Default to 25 fps if invalid
    } catch (Exception e) {
      println("Error parsing framerate from filename. Using default 25 fps.");
      e.printStackTrace();
      fileframerate = 25;
      aniFramerate = 40;
    }

    // Load the CSV file
    File csvFile = new File(fileInfo); // Use the absolute path directly

    if (csvFile.exists()) {
      try {
        // Use UTF-8 encoding when loading the table
        pixelTable = loadTable(csvFile.getAbsolutePath(), "header,csv");

        if (pixelTable != null) {
          int frmcnt = -1;
          int[][] tmpgrid = new int[x][y];
          // Initialize tmpgrid
          for (int i = 0; i < x; i++) {
            for (int j = 0; j < y; j++) {
              tmpgrid[i][j] = color(0, 0, 0, 0);
            }
          }
          int _c, _x, _y;
          int _f = -1;

          for (TableRow newPixelRow : pixelTable.rows()) {
            int newF;
            try {
              newF = newPixelRow.getInt("f");
            } catch (Exception e) {
              println("Invalid frame number in CSV. Skipping row.");
              continue;
            }

            if (_f != newF) { // New frame detected
              if (_f != -1) {
                animation.add(new frame(frmcnt, myClone(tmpgrid)));
              }
              frmcnt++;
              _f = newF;
              // Optionally reset tmpgrid here if needed
            }

            _x = newPixelRow.getInt("x");
            _y = newPixelRow.getInt("y");
            int r = newPixelRow.getInt("r");
            int g = newPixelRow.getInt("g");
            int b = newPixelRow.getInt("b");
            int a = newPixelRow.getInt("a");

            _c = color(r, g, b, a);

            if (_x >= 0 && _x < x && _y >= 0 && _y < y) { // Bounds checking
              tmpgrid[_x][_y] = _c;
            } else {
              println("Warning: Pixel coordinates out of bounds (" + _x + ", " + _y + "). Skipping pixel.");
            }
          }

          // Add the last frame if any frames were added
          if (_f != -1) {
            animation.add(new frame(frmcnt, myClone(tmpgrid)));
          }

          if (animation.size() == 0) {
            println("No valid frames found in the CSV file. Moving to next animation.");
            nextAnimation();
          } else {
            println("Imported " + animation.size() + " frames.");
          }
        } else {
          println("Failed to load table from file. Moving to next animation.");
          nextAnimation();
        }
      } catch (Exception e) {
        println("Exception occurred while loading animation: " + e.getMessage());
        e.printStackTrace();
        // Move to next animation if an error occurs
        nextAnimation();
      }
    } else {
      println("No .csv file found in the specified path. Moving to next animation.");
      nextAnimation();
    }
  } else {
    println("Playback iterator out of bounds. Moving to next animation.");
    nextAnimation();
  }
}

public void resetFrame() {
  // Reset frame
  if (paintgrid != null) {
    for (int i = 0; i < x; i++) {
      for (int j = 0; j < y; j++) {
        paintgrid[i][j] = color(0, 0, 0, 0);
      }
    }
  } else {
    println("paintgrid is null during resetFrame().");
  }
}

public void resetAnimation() {
  animation.clear();
}

public int[][] myClone(int[][] from) {
  int[][] returnArr = new int[x][y];

  for (int i = 0; i < x; i++) {
    for (int j = 0; j < y; j++) {
      returnArr[i][j] = from[i][j];
    }
  }
  return returnArr;
}




class AEC {
  AECPlugin plugin = new AECPlugin();
  HouseDrawer house = new HouseDrawer(plugin);
  
  public AEC() {
  }

  public void init() {
    plugin.setFrameWidth(width);
    plugin.init();
    loadConfig();
  }
    
  public void loadConfig() {
    plugin.loadConfig();
  }
  
  public void beginDraw() {
    scale(2 * plugin.scale, plugin.scale);
  }
  
  public void endDraw() {
    // reset of the transformation
    resetMatrix();
    
    loadPixels();
    plugin.update(pixels);
  }
  
  public void drawSides() {
    house.draw();
  }
  
  public void keyPressed(int value) {
    plugin.keyPressed(value, keyCode);
    
    if (value == 'i') {
      house.toggleIds();
    }
  }

  public void setActiveColor(Color c) {
    plugin.setActiveColor(c);
  }

  public void setInActiveColor(Color c) {
    plugin.setInActiveColor(c);
  }
  
  public int getScaleX() {
    return 2 * plugin.scale;
  }
  
  public int getScaleY() {
    return plugin.scale;
  }  
}

class HouseDrawer {
  AECPlugin aec;
  int size = 10;  
  PFont font;
  boolean showIds = false;
  
  public HouseDrawer(AECPlugin aec_) {
    aec = aec_;
    font = loadFont("LucidaConsole-8.vlw"); 
  }
  
  public void toggleIds() {
    showIds = !showIds;
  }
  
  public void draw() {
    resetMatrix();
    
    for (int i = 0; i < Building.SIDE.values().length; ++i) {
      Building.SIDE sideEnum = Building.SIDE.values()[i];
      Side side = aec.getSide(sideEnum);
      
      stroke(side.getColor().getRed(), side.getColor().getGreen(), side.getColor().getBlue(), side.getColor().getAlpha());
      noFill();
      drawSide(side);     
    }
  }
  
  public void drawSide(Side s) {
    int[][] adr = s.getWindowAddress();
    int pWidth = s.getPixelWidth();
    int pHeight = s.getPixelHeight();

    for (int y = 0; y < adr.length; ++y) {
      for (int x = 0; x < adr[y].length; ++x) {
        if (adr[y][x] > -1) {
          int fx = (s.getX() + x * pWidth) * aec.scale;
          int fy = (s.getY() + y * pHeight) * aec.scale;
          rect(fx, fy, pWidth * aec.scale, pHeight * aec.scale);
          
          if (showIds) {
            textFont(font, 8); 
            text("" + adr[y][x], fx + pWidth * aec.scale / 4, fy + pHeight * aec.scale * 0.9f);
          }
        }
      }
    }
  }
}
class frame 
{
  int _f;
  int[][] _framepaintgrid;
  
  public frame()
  {
  }
  public frame(int f, int[][]  framepaintgrid)
  {
    _f = f;
    _framepaintgrid = framepaintgrid;
  }
}


  public void settings() { size(1200, 450); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "AEC_SimpleRect_Player_24_GPT" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
