import controlP5.*; //<>// //<>// //<>// //<>//

ControlP5 cp5;
ColorPicker cp;

AEC aec;


color[][] paintgrid;
color brushcolor;
int x, y, _frame;
boolean starting, playback, editMode;
ArrayList <facadePixel>facadePixels = new ArrayList<facadePixel>();
Table pixelTable = new Table();

void setup() {
  frameRate(15);
  size(1200, 400);

  aec = new AEC();
  aec.init();

  starting = true; 
  playback = false;
  editMode = false;

  cp5 = new ControlP5(this);
  cp = cp5.addColorPicker("picker")
    .setPosition(10, 330)
    .setColorValue(color(255, 10, 1, 255));
    
  cp5.addTextfield("Frame_Input").setPosition(280, 330).setSize(100, 20).setAutoClear(false);
  cp5.addButton("Submit").setPosition(400, 330).setSize(60, 20);
  cp5.get(Textfield.class,"Frame_Input").setInputFilter(1);      // 1 = INTEGER
  cp5.get("Frame_Input").hide();
  cp5.get("Submit").hide();    

  brushcolor =  cp.getColorValue();
  pixelTable.addColumn("x");
  pixelTable.addColumn("y");
  pixelTable.addColumn("r");
  pixelTable.addColumn("g");
  pixelTable.addColumn("b");
  pixelTable.addColumn("a");

  _frame = 0;
}

void draw() {
  aec.beginDraw();
  background(0, 0, 0);
  noStroke();

  if (starting)
  {
    x = width/aec.getScaleX();
    y = height/aec.getScaleY();

    paintgrid = new color[x][y];

    for (int i = 0; i < x; i++) 
    {
      for (int j = 0; j < y; j++)
      {
        paintgrid[i][j] = color(0, 0, 0, 0 );
      }
    } 
    starting = false;
  } 

  if (playback)
  {
    if (facadePixels.size() == 0)
      importFromFile();
    
    resetFrame();

    print(_frame);
    print(".");
    int lastFrame_x =  facadePixels.get(facadePixels.size() - 1)._f;
    facadePixel fp;
    //for (int i = 0; i < lastFrame_x; i++)
    for (int i = 0; i < facadePixels.size(); i++)
    {      
      fp = facadePixels.get(i);

      if (fp._f == _frame)
        paintgrid[fp._x][fp._y] = fp._c;
    }
    _frame++;

    if (_frame > lastFrame_x)
      _frame = 0;
  }


  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      fill(paintgrid[i][j]);
      rect(i, j, 1, 1);
    }
  }
  fill(brushcolor);
  rect(mouseX/aec.getScaleX(), mouseY/aec.getScaleY(), 1, 1);
  // println("MouseX: " + mouseX, "X:  " + mouseX/aec.getScaleX(), "MouseY: " + mouseY, "Y: " + mouseY/aec.getScaleY());

  aec.endDraw();
  aec.drawSides();
  // println(frameRate);
}
void resetFrame()
{
  //reset frame
  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      fill(0);
      paintgrid[i][j] = 0;
    }
  }
}

void paint()
{
  if (((mouseX >= 0) && (mouseX < width)) && (mouseY >= 0) && (mouseY < height)) // so I can't get out of bounds
  {
    if ((mouseX >= 0) && (mouseY <= 270))
      paintgrid[mouseX/aec.getScaleX()][mouseY/aec.getScaleY()] = color(brushcolor);
  }
}
void erase()
{
  if (((mouseX >= 0) && (mouseX < width)) && (mouseY >= 0) && (mouseY < height)) // so I can't get out of bounds
  {
    if ((mouseX >= 0) && (mouseY <= 270))
      paintgrid[mouseX/aec.getScaleX()][mouseY/aec.getScaleY()] = 0;
  }
}

void mouseDragged()
{
  //println("MouseDragged");
  if (mouseButton == LEFT)
  {
    paint();
  } else if (mouseButton == RIGHT) 
  {
    erase();
  }
}

void mouseClicked()
{
  //println("MouseClicked");
  if (!playback)
  {

    if (mouseButton == LEFT)
    {
      paint();
    } else if (mouseButton == RIGHT) 
    {
      erase();
    }
  }
}

void keyPressed()
{
  if (!playback)
  {
    //aec.keyPressed(key);
    //println(keyCode);
    if (key == 'i')
    {
      println("IMPORT");
      importFromFile();
    }
    if (key == 'e') // Edit Mode
    {
      println("EDITMODE");
            
      if (editMode)
      {
        cp5.get("Frame_Input").hide();
        cp5.get("Submit").hide();
      }
      else
      {
        cp5.get("Frame_Input").show();
        cp5.get("Submit").show();
      }
      
      editMode = !editMode;
    }
    if ((keyCode == 10)  && !editMode)// RETURN
    {
      println("SAVEFRAME");
      saveFacadeFrame();
    }
    if ((keyCode == 10) && editMode)
    {
      insertFacadeFrame(int(cp5.get(Textfield.class,"Frame_Input").getText()));
    }
    if (key == 's')
    {
      println("EXPORT PLEASE WAIT!");
      exportToFile();
      println("FINISHED EXPORTING");
    }
  }
  if (key == 'p')
  {
    playback = !playback;
    _frame = 0;

    if (playback)
    {
      println("IMPORT and PLAY");
    } else
    {
      facadePixels.clear();
      resetFrame();
    }
  }
}

void importFromFile()
{
  facadePixels.clear();
  pixelTable = loadTable("animation.csv", "header");
  int _f = -1;

  for (TableRow newPixelRow : pixelTable.rows()) 
  {
    int _x = newPixelRow.getInt("x");
    int _y = newPixelRow.getInt("y");
    color _c = color(newPixelRow.getInt("r"), newPixelRow.getInt("g"), newPixelRow.getInt("b"), newPixelRow.getInt("a"));

    if (_x == -1)
      _f++;
    else
      facadePixels.add(new facadePixel(_f, _x, _y, _c));
  }
  println(pixelTable.getRowCount() + " total rows in table");
}

void readFrame(int _frame)
{
    if (facadePixels.size() == 0)
      importFromFile();
      
    resetFrame();
    
    int lastFrame_x = facadePixels.get(facadePixels.size() - 1)._f;
    
    println("Show Frame: ",_frame);
    
    if (_frame > lastFrame_x)
      _frame = lastFrame_x;
    
    for (int i = 0; i < facadePixels.size(); i++)
    {      
      facadePixel fp = facadePixels.get(i);
      if (fp._f == _frame)
        paintgrid[fp._x][fp._y] = fp._c;
    }
    println("FRAME LOADED");
}

public void Submit(int value)  // fired when SUBMIT-Button was pressed
{
  println("Button pressed:", cp5.get(Textfield.class,"Frame_Input").getText());
  
  readFrame(int(cp5.get(Textfield.class,"Frame_Input").getText()));
}

void exportToFile()
{
  TableRow newPixelRow; // New Frame -> -1,-1,-1,-1,-1  

  for (facadePixel fp : facadePixels)
  {
    newPixelRow = pixelTable.addRow();
    newPixelRow.setInt("x", fp._x);
    newPixelRow.setInt("y", fp._y);
    newPixelRow.setInt("r", int(red(fp._c)));
    newPixelRow.setInt("g", int(green(fp._c)));
    newPixelRow.setInt("b", int(blue(fp._c)));
    newPixelRow.setInt("a", int(alpha(fp._c)));
  }
  saveTable(pixelTable, "animation.csv");
}

void insertFacadeFrame(int _frame)
{
  int p = 0;
 for (facadePixel fp : facadePixels)
  {
    if (fp._f == _frame)
      p = facadePixels.indexOf(fp);
  }  
  println("UPDATE FRAME");
  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      //  println(paintgrid[i][j]);
      //facadePixels.set(_frame,new facadePixel(_frame,i, j, paintgrid[i][j]));
      if (paintgrid[i][j] != 0)
      {
        facadePixels.add(p,new facadePixel(i, j, paintgrid[i][j])); //<>//
      }
        //   facadePixels.add(new facadePixel(f,i,j,paintgrid[i][j]));
    }
  }
}

void saveFacadeFrame()
{
  facadePixels.add(new facadePixel(-1, -1, -1, -1));
  int f = 0;

  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      //  println(paintgrid[i][j]);
      if (paintgrid[i][j] != 0)
      {
        facadePixels.add(new facadePixel(i, j, paintgrid[i][j]));
        //   facadePixels.add(new facadePixel(f,i,j,paintgrid[i][j]));
        f++;
      }
    }
  }
  if (f == 0)
  {
    facadePixels.add(new facadePixel(0, 0, 0, color(0)));
    println("blankSpace");
  }

  /*
    TableRow newPixelRow = pixelTable.addRow(); // New Frame -> -1,-1,-1,-1,-1
   newPixelRow.setInt("x", -1);
   newPixelRow.setInt("y", -1);
   newPixelRow.setInt("r", -1);
   newPixelRow.setInt("g", -1);
   newPixelRow.setInt("b", -1);
   newPixelRow.setInt("a", -1);   
   
   for (int i = 0; i < x; i++) 
   {
   for (int j = 0; j < y; j++)
   {
   // facadePixels.add(new facadePixel(i,j,paintgrid[i][j]));
   newPixelRow = pixelTable.addRow();
   newPixelRow.setInt("x", i);
   newPixelRow.setInt("y", j);
   newPixelRow.setInt("r", int(red(paintgrid[i][j])));
   newPixelRow.setInt("g", int(green(paintgrid[i][j])));
   newPixelRow.setInt("b", int(blue(paintgrid[i][j])));
   newPixelRow.setInt("a", int(alpha(paintgrid[i][j])));
   }
   }   */
  println(facadePixels.size());
  println("FRAME SAVED");
}

public void controlEvent(ControlEvent c) 
{
  // when a value change from a ColorPicker is received, extract the ARGB values
  // from the controller's array value
  if (c.isFrom(cp)) 
  {
    int r = int(c.getArrayValue(0));
    int g = int(c.getArrayValue(1));
    int b = int(c.getArrayValue(2));
    int a = int(c.getArrayValue(3));
    brushcolor = color(r, g, b, a);
    println("New Color picked!");
  }
}
