/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class FacadeSample {
    private static List<Color> colors = new ArrayList<Color>();
    private static Color background = new Color(1, 1, 1);
    private static FrameBuffer frame = new FrameBuffer();
    private static Building building = new Building();

    private static void walkColors() {
        for (Color color : colors) {
            System.out.println("Set building to " + color.toString());
            frame.setColor(color);
            frame.flush();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        frame.setColor(background);
    }

    private static void walkSides() {
        for (Side side : building.getSides()) {
            frame.setColor(background);
            for (Color color : colors) {
                System.out.println("Set " + side.getName() + " to " + color.toString());
                side.setColor(frame, color);
                frame.flush();
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static void walkRows() {
        for (Color color : colors) {
            int row = 0;
            while (row < building.getNrRows()) {
                System.out.println("Set row " + row + " to " + color.toString());
                frame.setColor(background);
                for (Side side : building.getSides()) {
                    side.setRowColor(frame, row, color);
                }
                frame.flush();
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++row;
            }
        }
    }

    private static void walkColumns() {
        for (Color color : colors) {
            int column = 0;
            while (column < building.getNrColumns()) {
                System.out.println("Set column " + column + " to " + color.toString());
                frame.setColor(background);
                for (Side side : building.getSides()) {
                    side.setColumnColor(frame, column, color);
                }
                frame.flush();
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++column;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("Facade Sample");
        colors.add(Color.red);
        colors.add(Color.green);
        colors.add(Color.blue);
        colors.add(Color.yellow);
        colors.add(Color.magenta);
        colors.add(Color.cyan);
        colors.add(new Color(254, 254, 254));
        FacadeSample.walkColors();
        FacadeSample.walkSides();
        FacadeSample.walkRows();
        FacadeSample.walkColumns();
    }
}

