/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class FrameBuffer {
    private final int packageSize = 5;
    private final int nrAddresses = 1085;
    private final int offsetRed = 2;
    private final int offsetGreen = 3;
    private final int offsetBlue = 4;
    private byte[] frameBuffer = new byte[5425];
    private InetAddress address;
    private int port = 8080;

    public FrameBuffer() {
        int address = 0;
        while (address < 1085) {
            this.frameBuffer[address * 5 + 0] = (byte)(address % 256);
            this.frameBuffer[address * 5 + 1] = (byte)(address / 256);
            this.frameBuffer[address * 5 + 2] = 0;
            this.frameBuffer[address * 5 + 3] = 0;
            this.frameBuffer[address * 5 + 4] = 0;
            ++address;
        }
        try {
            this.address = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void setIp(InetAddress adr) {
        this.address = adr;
    }

    public void setPort(int po) {
        this.port = po;
    }

    public void setColor(Color color) {
        int address = 0;
        while (address < 1085) {
            this.frameBuffer[address * 5 + 2] = (byte)color.getRed();
            this.frameBuffer[address * 5 + 3] = (byte)color.getGreen();
            this.frameBuffer[address * 5 + 4] = (byte)color.getBlue();
            ++address;
        }
    }

    public void setColor(int address, Color color) {
        if (address >= 0 && address < 1085) {
            this.frameBuffer[address * 5 + 2] = (byte)color.getRed();
            this.frameBuffer[address * 5 + 3] = (byte)color.getGreen();
            this.frameBuffer[address * 5 + 4] = (byte)color.getBlue();
        }
    }

    public void flush() {
        try {
            DatagramPacket packet = new DatagramPacket(this.frameBuffer, this.frameBuffer.length, this.address, this.port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
        }
        catch (Exception e) {
            System.out.println("Exception when sending framebuffer: " + e.getMessage());
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getIp() {
        return this.address.getHostAddress();
    }
}

