/* autogenerated by Processing revision 1292 on 2020-07-10 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import controlP5.*;
import java.awt.Color;
import org.aec.facade.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class AEC_SimpleRect_Drawer_11 extends PApplet {

 //<>// //<>// //<>//

ControlP5 cp5;
ColorPicker cp;
ColorWheel cw;

AEC aec;


int[][] paintgrid,prev_paintgrid;
int[][] selectgrid;
int brushcolor;
int x, y, _frame, cur_frame,aniFramerate,brushsize, startMouseX, startMouseY, mouseReleaseX, mouseReleaseY, selGridx, selGridy;   //_frame = Frame for Playback, cur_frame = Current Frame in Drawingmode
boolean starting, playback, editMode, frameissaving,selectMode, selectStarted, moveMode;
ArrayList <frame> animation = new ArrayList<frame>();
Table pixelTable = new Table();
Table resetTable = new Table();
RadioButton myFramerate,brushsizeRB;
long flashTime, triggerframetime;
Textlabel infotext;

public void setup() {
  frameRate(50);
  
  /* size commented out by preprocessor */;

  aec = new AEC();
  aec.init();

  starting = true; 
  playback = false;
  editMode = false;
  frameissaving = false;
  selectMode = false;
  selectStarted = false;
  moveMode = false;
  
  flashTime = 0;
  aniFramerate = 67;
  startMouseX = 0;
  startMouseY = 0;
  mouseReleaseX = 0;
  mouseReleaseY = 0;
  triggerframetime = 0;

  cp5 = new ControlP5(this);
  /*cp = cp5.addColorPicker("picker")
    .setPosition(10, 330)
    .setColorValue(color(255, 10, 1, 255));*/
  
  cw = cp5.addColorWheel("c" , 250 , 10 , 200 )
    .setPosition(10, 230)
    .setRGB(color(128,0,255));
    
  myFramerate = cp5.addRadioButton("radioButton")
         .setPosition(300,420)
         .setSize(20,20)
         .setColorForeground(color(120))
         .setColorActive(color(255))
         .setColorLabel(color(255))
         .setItemsPerRow(5)
         .setSpacingColumn(30)
         .addItem("1",1)
         .addItem("5",2)
         .addItem("15",3)
         .addItem("25",4)
         ;
    myFramerate.activate(2);

    brushsizeRB = cp5.addRadioButton("brushsizeradiobutton")
         .setPosition(300,380)
         .setSize(20,20)
         .setColorForeground(color(120))
         .setColorActive(color(255))
         .setColorLabel(color(255))
         .setItemsPerRow(5)
         .setSpacingColumn(30)
         .addItem("S",11)
         .addItem("M",12)
         .addItem("L",13)
         .addItem("XL",14)
         ;
    brushsizeRB.activate(0);     
  
  cp5.addButton("edit")
     .setValue(0)
     .setPosition(900,380)
     .setSize(100,19)
     ;
 
  cp5.addButton("stamp")
     .setValue(0)
     .setPosition(750,380)
     .setSize(100,19)
     ;
  
  cp5.addButton("play")
     .setPosition(600,380)
     .setSize(100,19)
     .setValue(0)
     .setSwitch(false)
     ;
     
  cp5.addButton("export")
     .setPosition(1050,380)
     .setSize(100,19)
     .setValue(0)
     .setSwitch(false)
     ;
    
  cp5.addTextfield("Frame_Input").setPosition(900, 320).setSize(100, 20).setAutoClear(false).keepFocus(true);
  cp5.addButton("Submit").setPosition(1020, 320).setSize(60, 20);
  cp5.get(Textfield.class,"Frame_Input").setInputFilter(1);      // 1 = INTEGER
  cp5.get("Frame_Input").hide();
  cp5.get("Submit").hide();    

  infotext = cp5.addTextlabel("label")
                    .setText("Starting")
                    .setPosition(1050,420)
                    .setColorValue(color(255))
                    .setFont(createFont("Verdana",10))
                    ;

 // brushcolor =  cp.getColorValue();
  brushcolor = cp5.get(ColorWheel.class,"c").getRGB();
  
  pixelTable.addColumn("f");
  pixelTable.addColumn("x");
  pixelTable.addColumn("y");
  pixelTable.addColumn("r");
  pixelTable.addColumn("g");
  pixelTable.addColumn("b");
  pixelTable.addColumn("a");

  _frame = 0;
}

public void draw() {
  aec.beginDraw();

 // background(0, 0, 0);
 
  if (flashTime > millis())
  {
    fill(255);
    rect(800, 20, 100, 100);
    delay(100);
  }
  
  noStroke();

  if (starting)
  {
    x = width/aec.getScaleX();
    y = height/aec.getScaleY();

    paintgrid = new int[x][y];
    prev_paintgrid = new int[x][y];
    cur_frame = 0;
    brushsize = 1;

    for (int i = 0; i < x; i++) 
    {
      for (int j = 0; j < y; j++)
      {
        paintgrid[i][j] = color(0, 0, 0, 0 );
        prev_paintgrid[i][j] = color(0, 0, 0, 0 );
      }
    } 
    starting = false;
  } 

  if ((playback) && (triggerframetime < millis()))
  {
    triggerframetime = millis() + aniFramerate;
    if (animation.size() == 0)
      importFromFile();
    
    resetFrame();

    infotext.setText("" + _frame);
    print(".");
    int lastFrame_x =  animation.size() - 1;
    
    frame f,prev_f;
     
    prev_f = null;
      
    f = animation.get(_frame);
    paintgrid = myClone(f._framepaintgrid);
     
    _frame++;

    if (_frame > lastFrame_x)
      _frame = 0;
  }

  // drawing the paintrgrid onto the canvas
  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      fill(paintgrid[i][j]);
      rect(i, j, 1, 1);
    }
  }

  if ((!selectMode) && (!moveMode))
  {
    fill(brushcolor);
    if (mouseX < 1350 & mouseY < 225)
      rect(mouseX/aec.getScaleX()-brushsize, mouseY/aec.getScaleY()-brushsize, brushsize, brushsize);
  } else if (moveMode)
  {
    moveObject();
  }
  
  aec.endDraw();
  aec.drawSides();
  // println(frameRate);
}
public void resetFrame()
{
  //reset frame
  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      fill(0);
      paintgrid[i][j] = 0;
    }
  }
}

public void resetAnimation()
{
  animation.clear();  
}

public void paint()
{
  if (((mouseX >= 0) && (mouseX < width + (brushsize-1)*aec.getScaleX() )) && (mouseY >= 0) && (mouseY < height)) // so I can't get out of bounds
  {
    if ((mouseX >= 0) && (mouseY <= 270))
    {
      for(int i = 0; i < brushsize; i++)
      {
        for(int j = 0; j < brushsize; j++)
        {
          if (((mouseX/aec.getScaleX()-brushsize+i >= 0) && (mouseY/aec.getScaleY()-brushsize+j) >= 0))
            paintgrid[mouseX/aec.getScaleX()-brushsize+i][mouseY/aec.getScaleY()-brushsize+j] = color(brushcolor);
        }
      }
    }
  }
}
public void erase()
{
  if (((mouseX >= 0) && (mouseX < width + (brushsize-1)*aec.getScaleX())) && (mouseY >= 0) && (mouseY < height)) // so I can't get out of bounds
  {
    if ((mouseX >= 0) && (mouseY <= 270))
    {
      for(int i = 0; i < brushsize; i++)
      {
        for(int j = 0; j < brushsize; j++)
        {
          if (((mouseX/aec.getScaleX()-brushsize+i >= 0) && (mouseY/aec.getScaleY()-brushsize+j) >= 0))
            paintgrid[mouseX/aec.getScaleX()-brushsize+i][mouseY/aec.getScaleY()-brushsize+j] = 0;
        }
      }
    }
  }
}

public void mouseReleased()
{
    if (mouseY < 300) {
  if (moveMode)
  {
   // if (((mouseX >= 0) && (mouseX + (selGridx-1)*aec.getScaleX() < width)) && (mouseY >= 0) && (mouseY < height)) // so I can't get out of bounds
  //  {
      if ((mouseX >= 0) && (mouseY <= 270))
      {
        for(int i = 0; i < selGridx; i++)
        {
          for(int j = 0; j < selGridy; j++)
          {
            if (((mouseX/aec.getScaleX()-selGridx+i >= 0) && (mouseY/aec.getScaleY()-selGridy+j) >= 0))
              paintgrid[mouseX/aec.getScaleX()+i-selGridx][mouseY/aec.getScaleY()+j-selGridy] = selectgrid[i][j];
          }
   //     }
      }
    }
  //  moveMode = false;
  //  selectMode = false;
  }else if ((selectMode) && (!moveMode))
  {
      int k, l;
    
      k = 0;
      l = 0;
      
      mouseReleaseX = mouseX/aec.getScaleX();
      mouseReleaseY = mouseY/aec.getScaleY();
      
      selGridx = mouseReleaseX - startMouseX;
      selGridy = mouseReleaseY - startMouseY;
      
      if ((selGridx > 0) && (selGridy > 0))
      {
        selectgrid = new int[selGridx][selGridy];
        
        for (int i = startMouseX; i < mouseReleaseX; i++) 
        {
          for (int j = startMouseY; j < mouseReleaseY; j++)
          {
            selectgrid[k][l] = paintgrid[i][j];
            l++;
          }
          l = 0;
          k++;
        }
        
        moveMode = true;
      }
      selectStarted = false;
   } else if ((!playback) && (!selectMode) && (!moveMode))
  {
    if (mouseButton == LEFT)
    {
      paint();
    } else if (mouseButton == RIGHT) 
    {
      erase();
    }
  }
    }
}

public void mouseDragged()
{
 // infotext.setText("MouseDragged");
  if (mouseY < 400)
  {
  if (!selectMode)
  {
    if (mouseButton == LEFT)
    {
      paint();
    } else if (mouseButton == RIGHT) 
    {
      erase();
    }
  }
  else if ((!selectStarted) && (!moveMode))
  {
    selectStarted = true;
    startMouseX = mouseX/aec.getScaleX();
    startMouseY = mouseY/aec.getScaleY();
  } else if (selectStarted)
  {
      for(int i = startMouseX; i < mouseX/aec.getScaleX(); i++)
      {
        for(int j = startMouseY; j < mouseY/aec.getScaleY(); j++)
        {
          int temp = paintgrid[i][j];
          fill(color(red(temp), green(temp)+255, blue(temp)));
          rect(i*aec.getScaleX(),j*aec.getScaleY(),1*aec.getScaleX(),1*aec.getScaleY());
          //paintgrid[i][j] = color(red(temp), green(temp), blue(temp), 1);
        }
      }
   }
  }
}

public void mouseClicked()
{
 // infotext.setText("MouseClicked");

}

public void keyPressed()
{
  if (keyCode == 17)
  {
    selectMode = !selectMode;
    
    infotext.setText("Selectmode: " + selectMode);
    if (!selectMode)
      moveMode = false;
  }
  if ((!playback))// && (!selectMode))
  {
    //aec.keyPressed(key);
    infotext.setText("" + keyCode);
    if (key == 'i')
    {
      infotext.setText("IMPORT");
      importFromFile();
    }
    if (key == 'e') // Edit Mode
    {
      infotext.setText("EDITMODE");
            
      if (editMode)
      {
        cp5.get("Frame_Input").hide();
        cp5.get("Submit").hide();
      }
      else
      {
        cp5.get("Frame_Input").show();
        cp5.get("Submit").show();
      }
      
      editMode = !editMode;
    }
    if ((keyCode == 32)  && !editMode)// RETURN
    {
      flashTime = millis() + 1000;

      fill(255);
      rect(800, 20, 100, 100);
      infotext.setText("SAVEFRAME");
      saveFacadeFrame(cur_frame++);
      
      if ((cur_frame % 25) == 0)
      {
         infotext.setText("AUTOSAVE");
         exportToFile();// AUTOSAVE/EXPORT
      }
    }
    if ((keyCode == 32) && editMode)
    {      
      infotext.setText("UPDATE FRAME");
      insertFacadeFrame(PApplet.parseInt(cp5.get(Textfield.class,"Frame_Input").getText()));

      flashTime = millis() + 1000;

      fill(255);
      rect(800, 20, 100, 100);
    }
    if ((keyCode == 10) && editMode)
    {      
      infotext.setText("Read frame:" + cp5.get(Textfield.class,"Frame_Input").getText());
  
      readFrame(PApplet.parseInt(cp5.get(Textfield.class,"Frame_Input").getText()));
    }
    if (key == 's')
    {
      infotext.setText("EXPORT PLEASE WAIT!");
      exportToFile();
      infotext.setText("FINISHED EXPORTING");
    }
  }
  if ((key == 'p') && (!selectMode) && (!editMode))
  {
    playback = !playback;
    infotext.setText("Playback: " + playback);
    _frame = 0;
    triggerframetime = millis() + aniFramerate;

    if (!playback)
    {
      infotext.setText("PLAYBACK FINISHED");
      showFacadeFrame(animation.size()-1);   // draw last frame on the board
    }
  }
}

public void importFromFile()
{ 
  resetFrame();
  resetAnimation();
  infotext.setText(animation.size() - 1 + " clear Framesize");
  pixelTable.clearRows(); 
  pixelTable = loadTable("animation.csv", "header");

  int rowcnt = 0;
  int frmcnt = 0;
  int[][] tmpgrid = new int[x][y];
  int _c,_x,_y,_f = 0;
  
  for (TableRow newPixelRow : pixelTable.rows()) // pixelTable is only used for import / export
  {
    if (_f != newPixelRow.getInt("f"))    // if there is a new frame finish old frame
    {
      frmcnt++;
      animation.add(new frame(frmcnt-1, myClone(tmpgrid)));
    } 
    
    _f = newPixelRow.getInt("f");
    _x = newPixelRow.getInt("x");
    _y = newPixelRow.getInt("y");
    _c = color(newPixelRow.getInt("r"), newPixelRow.getInt("g"), newPixelRow.getInt("b"), newPixelRow.getInt("a"));
  
    if (_x >= 0)      // -1 = blank frame
      tmpgrid[_x][_y] = _c;   
    /*else
      tmpgrid = new color[x][y];*/ 
    
    rowcnt++;
  }

  frmcnt++;
  animation.add(new frame(frmcnt-1, myClone(tmpgrid)));  // add last frame
  
  infotext.setText(rowcnt + " Rows imported");
  infotext.setText("Framesize: " + animation.size());
  cur_frame = animation.size()-1;

}

public void readFrame(int _frame)
{
    if (animation.size() == 0)
      importFromFile();
    
    showFacadeFrame(_frame);
    
    infotext.setText("FRAME LOADED");
}

public void Submit(int value)  // fired when SUBMIT-Button was pressed
{
  infotext.setText("Read frame:"+ cp5.get(Textfield.class,"Frame_Input").getText());
  
  readFrame(PApplet.parseInt(cp5.get(Textfield.class,"Frame_Input").getText()));
}

public void exportToFile()
{
  TableRow newPixelRow = null; // New Frame -> -1,-1,-1,-1,-1  
  Boolean noChange = true;
  pixelTable.clearRows();  
  frame f = null;
  frame prev_f = new frame(0, new int[x][y]);

  for (int z = 0; z < animation.size(); z++)
  {
    f = animation.get(z);
    
    if (z > 0)
      prev_f = animation.get(z-1);
    
    for (int i = 0; i < x; i++) 
    {
      for (int j = 0; j < y; j++)
      {
        if (f._framepaintgrid[i][j] != prev_f._framepaintgrid[i][j])
        {
          newPixelRow = pixelTable.addRow();
          newPixelRow.setInt("f", f._f);
          newPixelRow.setInt("x", i);
          newPixelRow.setInt("y", j);
          newPixelRow.setInt("r", PApplet.parseInt(red(f._framepaintgrid[i][j])));
          newPixelRow.setInt("g", PApplet.parseInt(green(f._framepaintgrid[i][j])));
          newPixelRow.setInt("b", PApplet.parseInt(blue(f._framepaintgrid[i][j])));
          newPixelRow.setInt("a", PApplet.parseInt(alpha(f._framepaintgrid[i][j])));
          noChange = false;
        }
      }
    }
    
    if (noChange && (z > 0))
    {
      f = animation.get(z-1);
      newPixelRow = pixelTable.addRow();
      newPixelRow.setInt("f", f._f+1);
      newPixelRow.setInt("x", -1);
      newPixelRow.setInt("y", -1);
      newPixelRow.setInt("r", -1);
      newPixelRow.setInt("g", -1);
      newPixelRow.setInt("b", -1);
      newPixelRow.setInt("a", -1);
    }
    else if (z == 0)  // first frame IF it is all black
    {
      f = animation.get(0);
      newPixelRow = pixelTable.addRow();
      newPixelRow.setInt("f", 0);
      newPixelRow.setInt("x", 0);
      newPixelRow.setInt("y", 0);
      newPixelRow.setInt("r", 0);
      newPixelRow.setInt("g", 0);
      newPixelRow.setInt("b", 0);
      newPixelRow.setInt("a", 0);     
    }
    noChange = true;
  }
    
  saveTable(pixelTable, "animation.csv","csv");
  infotext.setText(pixelTable.getRowCount() + " rows exported");
 
  pixelTable.clearRows();
}

public void showFacadeFrame(int _frame)
{
  if (_frame >= animation.size())
    _frame = animation.size()-1; 
  
  resetFrame();

  paintgrid = myClone(animation.get(_frame)._framepaintgrid);
  infotext.setText("Show Frame: " + _frame);
  
}

public void insertFacadeFrame(int _frame)
{ 
  if (_frame >= animation.size())
    _frame = animation.size()-1;   
  
  animation.remove(_frame);
  animation.add(_frame, new frame(_frame, myClone(paintgrid)));
}

public int[][] myClone(int[][] from)
{
  int[][] returnArr = new int[x][y];
  
  for (int i = 0; i < x; i++) 
  {
    for (int j = 0; j < y; j++)
    {
      returnArr[i][j] = from[i][j]; 
    }
  }
  return returnArr;
}

public void saveFacadeFrame(int _cur_frame)
{ 
  animation.add(new frame(_cur_frame, myClone(paintgrid)));

  infotext.setText("Frame: " + _cur_frame);
  infotext.setText("FRAME SAVED");
}
public void controlEvent(ControlEvent c) 
{
  // when a value change from a ColorPicker is received, extract the ARGB values
  // from the controller's array value
  /*if (c.isFrom(cp)) 
  {
    int r = int(c.getArrayValue(0));
    int g = int(c.getArrayValue(1));
    int b = int(c.getArrayValue(2));
    int a = int(c.getArrayValue(3));
    brushcolor = color(r, g, b, a);
    infotext.setText("New Color picked!");
  }*/
  if (c.isFrom(cw)) //colorWheel
  {

    brushcolor = cp5.get(ColorWheel.class,"c").getRGB();
    infotext.setText("New Color picked!");
  }  
}
public void radioButton(int a) {
  println(a);
  switch(a) {
    case(1): aniFramerate = 1000; break;
    case(2): aniFramerate = 200; break;
    case(3): aniFramerate = 67; break;
    case(4): aniFramerate = 40; break;
  }
  infotext.setText("Framerate: " + aniFramerate);
}
public void brushsizeradiobutton(int a) {
  switch(a) {
    case(11): brushsize = 1; break;
    case(12): brushsize = 2; break;
    case(13): brushsize = 4; break;
    case(14): brushsize = 8; break;
  }
  infotext.setText("Brushsize: " + brushsize);
}


public void play(int theValue) {
    if ((!starting) && (!editMode))
    {
      playback = !playback;
      infotext.setText("Playback: " + playback);

      _frame = 0;
      triggerframetime = millis() + aniFramerate;

      if (!playback)
      {
        infotext.setText("PLAYBACK FINISHED");
        showFacadeFrame(animation.size()-1);   // draw last frame on the board
      }
    }
}

public void export(int theValue) {
  if (!starting)
  {  
    exportToFile();
  }
}

public void stamp(int theValue){
  if (!starting)
  {  
    selectMode = !selectMode;
    
    infotext.setText("Selectmode: " + selectMode);
    if (!selectMode)
      moveMode = false;
  }
}

public void moveObject()
{
  
  
    if (mouseX < 1350 & mouseY < 225)
{
      for(int i = 0; i < selGridx; i++)
      {
        for(int j = 0; j < selGridy; j++)
        {
          int temp = selectgrid[i][j];
        //  paintgrid[i][j] = color(red(temp), green(temp), blue(temp), 1);
          fill(color(red(temp), green(temp)+255, blue(temp)));
          rect(mouseX/aec.getScaleX()+i-selGridx, mouseY/aec.getScaleY()+j-selGridy,1,1);
        }
      }
  }
}

public void edit(int theValue) {
  if (!starting)
  {  
    infotext.setText("EDITMODE");
          
    if (editMode)
    {
      cp5.get("Frame_Input").hide();
      cp5.get("Submit").hide();
      cp5.get(Textfield.class,"Frame_Input").clear();
    }
    else
    {
      cp5.get("Frame_Input").show();
      cp5.get("Submit").show();
      cp5.get(Textfield.class,"Frame_Input").setFocus(true);
    }
    
    editMode = !editMode;
  }
}




class AEC {
  AECPlugin plugin = new AECPlugin();
  HouseDrawer house = new HouseDrawer(plugin);
  
  public AEC() {
  }

  public void init() {
    plugin.setFrameWidth(width);
    plugin.init();
    loadConfig();
  }
    
  public void loadConfig() {
    plugin.loadConfig();
  }
  
  public void beginDraw() {
    scale(2 * plugin.scale, plugin.scale);
  }
  
  public void endDraw() {
    // reset of the transformation
    resetMatrix();
    
    loadPixels();
    plugin.update(pixels);
  }
  
  public void drawSides() {
    house.draw();
  }
  
  public void keyPressed(int value) {
    plugin.keyPressed(value, keyCode);
    
    if (value == 'i') {
      house.toggleIds();
    }
  }

  public void setActiveColor(Color c) {
    plugin.setActiveColor(c);
  }

  public void setInActiveColor(Color c) {
    plugin.setInActiveColor(c);
  }
  
  public int getScaleX() {
    return 2 * plugin.scale;
  }
  
  public int getScaleY() {
    return plugin.scale;
  }  
}

class HouseDrawer {
  AECPlugin aec;
  int size = 10;  
  PFont font;
  boolean showIds = false;
  
  public HouseDrawer(AECPlugin aec_) {
    aec = aec_;
    font = loadFont("LucidaConsole-8.vlw"); 
  }
  
  public void toggleIds() {
    showIds = !showIds;
  }
  
  public void draw() {
    resetMatrix();
    
    for (int i = 0; i < Building.SIDE.values().length; ++i) {
      Building.SIDE sideEnum = Building.SIDE.values()[i];
      Side side = aec.getSide(sideEnum);
      
      stroke(side.getColor().getRed(), side.getColor().getGreen(), side.getColor().getBlue(), side.getColor().getAlpha());
      noFill();
      drawSide(side);     
    }
  }
  
  public void drawSide(Side s) {
    int[][] adr = s.getWindowAddress();
    int pWidth = s.getPixelWidth();
    int pHeight = s.getPixelHeight();

    for (int y = 0; y < adr.length; ++y) {
      for (int x = 0; x < adr[y].length; ++x) {
        if (adr[y][x] > -1) {
          int fx = (s.getX() + x * pWidth) * aec.scale;
          int fy = (s.getY() + y * pHeight) * aec.scale;
          rect(fx, fy, pWidth * aec.scale, pHeight * aec.scale);
          
          if (showIds) {
            textFont(font, 8); 
            text("" + adr[y][x], fx + pWidth * aec.scale / 4, fy + pHeight * aec.scale * 0.9f);
          }
        }
      }
    }
  }
}
class frame 
{
  int _f;
  int[][] _framepaintgrid;
  
  public frame()
  {
  }
  public frame(int f, int[][]  framepaintgrid)
  {
    _f = f;
    _framepaintgrid = framepaintgrid;
  }
}


  public void settings() { size(1200, 450); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "AEC_SimpleRect_Drawer_11" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
