/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ColorPicker;
import controlP5.ColorWheel;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.RadioButton;
import controlP5.Textfield;
import controlP5.Textlabel;
import java.awt.Color;
import java.util.ArrayList;
import org.aec.facade.AECPlugin;
import org.aec.facade.Building;
import org.aec.facade.Side;
import processing.core.PApplet;
import processing.core.PFont;
import processing.data.Table;
import processing.data.TableRow;

public class AEC_SimpleRect_Drawer_09
extends PApplet {
    ControlP5 cp5;
    ColorPicker cp;
    ColorWheel cw;
    AEC aec;
    int[][] paintgrid;
    int[][] prev_paintgrid;
    int[][] selectgrid;
    int brushcolor;
    int x;
    int y;
    int _frame;
    int cur_frame;
    int aniFramerate;
    int brushsize;
    int startMouseX;
    int startMouseY;
    int mouseReleaseX;
    int mouseReleaseY;
    int selGridx;
    int selGridy;
    boolean starting;
    boolean playback;
    boolean editMode;
    boolean frameissaving;
    boolean selectMode;
    boolean selectStarted;
    boolean moveMode;
    ArrayList<frame> animation = new ArrayList();
    Table pixelTable = new Table();
    Table resetTable = new Table();
    RadioButton myFramerate;
    RadioButton brushsizeRB;
    long flashTime;
    long triggerframetime;
    Textlabel infotext;

    public void setup() {
        this.frameRate(50.0f);
        this.aec = new AEC();
        this.aec.init();
        this.starting = true;
        this.playback = false;
        this.editMode = false;
        this.frameissaving = false;
        this.selectMode = false;
        this.selectStarted = false;
        this.moveMode = false;
        this.flashTime = 0L;
        this.aniFramerate = 67;
        this.startMouseX = 0;
        this.startMouseY = 0;
        this.mouseReleaseX = 0;
        this.mouseReleaseY = 0;
        this.triggerframetime = 0L;
        this.cp5 = new ControlP5((PApplet)this);
        this.cw = ((ColorWheel)this.cp5.addColorWheel("c", 250, 10, 200).setPosition(10.0f, 230.0f)).setRGB(this.color(128, 0, 255));
        this.myFramerate = ((RadioButton)((RadioButton)((RadioButton)((RadioButton)this.cp5.addRadioButton("radioButton").setPosition(300.0f, 420.0f)).setSize(20, 20).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setItemsPerRow(5).setSpacingColumn(30).addItem("1", 1.0f).addItem("5", 2.0f).addItem("15", 3.0f).addItem("25", 4.0f);
        this.myFramerate.activate(2);
        this.brushsizeRB = ((RadioButton)((RadioButton)((RadioButton)((RadioButton)this.cp5.addRadioButton("brushsizeradiobutton").setPosition(300.0f, 380.0f)).setSize(20, 20).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setItemsPerRow(5).setSpacingColumn(30).addItem("S", 11.0f).addItem("M", 12.0f).addItem("L", 13.0f).addItem("XL", 14.0f);
        this.brushsizeRB.activate(0);
        ((Button)this.cp5.addButton("edit").setValue(0.0f).setPosition(900.0f, 380.0f)).setSize(100, 19);
        ((Button)this.cp5.addButton("stamp").setValue(0.0f).setPosition(750.0f, 380.0f)).setSize(100, 19);
        ((Button)((Button)this.cp5.addButton("play").setPosition(600.0f, 380.0f)).setSize(100, 19)).setValue(0.0f).setSwitch(false);
        ((Button)((Button)this.cp5.addButton("export").setPosition(1050.0f, 380.0f)).setSize(100, 19)).setValue(0.0f).setSwitch(false);
        ((Textfield)this.cp5.addTextfield("Frame_Input").setPosition(900.0f, 320.0f)).setSize(100, 20).setAutoClear(false).keepFocus(true);
        ((Button)this.cp5.addButton("Submit").setPosition(1020.0f, 320.0f)).setSize(60, 20);
        ((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).setInputFilter(1);
        this.cp5.get("Frame_Input").hide();
        this.cp5.get("Submit").hide();
        this.infotext = ((Textlabel)((Textlabel)this.cp5.addTextlabel("label").setText("Starting").setPosition(1050.0f, 420.0f)).setColorValue(this.color(255))).setFont(this.createFont("Verdana", 10.0f));
        this.brushcolor = ((ColorWheel)this.cp5.get(ColorWheel.class, "c")).getRGB();
        this.pixelTable.addColumn("f");
        this.pixelTable.addColumn("x");
        this.pixelTable.addColumn("y");
        this.pixelTable.addColumn("r");
        this.pixelTable.addColumn("g");
        this.pixelTable.addColumn("b");
        this.pixelTable.addColumn("a");
        this._frame = 0;
    }

    public void draw() {
        int i;
        this.aec.beginDraw();
        if (this.flashTime > (long)this.millis()) {
            this.fill(255);
            this.rect(800.0f, 20.0f, 100.0f, 100.0f);
            this.delay(100);
        }
        this.noStroke();
        if (this.starting) {
            this.x = this.width / this.aec.getScaleX();
            this.y = this.height / this.aec.getScaleY();
            this.paintgrid = new int[this.x][this.y];
            this.prev_paintgrid = new int[this.x][this.y];
            this.cur_frame = 0;
            this.brushsize = 1;
            i = 0;
            while (i < this.x) {
                int j = 0;
                while (j < this.y) {
                    this.paintgrid[i][j] = this.color(0, 0, 0, 0);
                    this.prev_paintgrid[i][j] = this.color(0, 0, 0, 0);
                    ++j;
                }
                ++i;
            }
            this.starting = false;
        }
        if (this.playback && this.triggerframetime < (long)this.millis()) {
            this.triggerframetime = this.millis() + this.aniFramerate;
            if (this.animation.size() == 0) {
                this.importFromFile();
            }
            this.resetFrame();
            this.infotext.setText("" + this._frame);
            AEC_SimpleRect_Drawer_09.print((String)".");
            int lastFrame_x = this.animation.size() - 1;
            frame f = this.animation.get(this._frame);
            this.paintgrid = this.myClone(f._framepaintgrid);
            ++this._frame;
            if (this._frame > lastFrame_x) {
                this._frame = 0;
            }
        }
        i = 0;
        while (i < this.x) {
            int j = 0;
            while (j < this.y) {
                this.fill(this.paintgrid[i][j]);
                this.rect(i, j, 1.0f, 1.0f);
                ++j;
            }
            ++i;
        }
        if (!this.selectMode && !this.moveMode) {
            this.fill(this.brushcolor);
            if (this.mouseX < 1350 & this.mouseY < 225) {
                this.rect(this.mouseX / this.aec.getScaleX() - this.brushsize, this.mouseY / this.aec.getScaleY() - this.brushsize, this.brushsize, this.brushsize);
            }
        } else if (this.moveMode) {
            this.moveObject();
        }
        this.aec.endDraw();
        this.aec.drawSides();
    }

    public void resetFrame() {
        int i = 0;
        while (i < this.x) {
            int j = 0;
            while (j < this.y) {
                this.fill(0);
                this.paintgrid[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void resetAnimation() {
        this.animation.clear();
    }

    public void paint() {
        if (this.mouseX >= 0 && this.mouseX + (this.brushsize - 1) * this.aec.getScaleX() < this.width && this.mouseY >= 0 && this.mouseY < this.height && this.mouseX >= 0 && this.mouseY <= 270) {
            int i = 0;
            while (i < this.brushsize) {
                int j = 0;
                while (j < this.brushsize) {
                    if (this.mouseX / this.aec.getScaleX() - this.brushsize + i >= 0 && this.mouseY / this.aec.getScaleY() - this.brushsize + j >= 0) {
                        this.paintgrid[this.mouseX / this.aec.getScaleX() - this.brushsize + i][this.mouseY / this.aec.getScaleY() - this.brushsize + j] = this.color(this.brushcolor);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void erase() {
        if (this.mouseX >= 0 && this.mouseX + (this.brushsize - 1) * this.aec.getScaleX() < this.width && this.mouseY >= 0 && this.mouseY < this.height && this.mouseX >= 0 && this.mouseY <= 270) {
            int i = 0;
            while (i < this.brushsize) {
                int j = 0;
                while (j < this.brushsize) {
                    if (this.mouseX / this.aec.getScaleX() - this.brushsize + i >= 0 && this.mouseY / this.aec.getScaleY() - this.brushsize + j >= 0) {
                        this.paintgrid[this.mouseX / this.aec.getScaleX() + i][this.mouseY / this.aec.getScaleY() + j] = 0;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void mouseReleased() {
        if (this.mouseY < 300) {
            if (this.moveMode) {
                if (this.mouseX >= 0 && this.mouseX + (this.selGridx - 1) * this.aec.getScaleX() < this.width && this.mouseY >= 0 && this.mouseY < this.height && this.mouseX >= 0 && this.mouseY <= 270) {
                    int i = 0;
                    while (i < this.selGridx) {
                        int j = 0;
                        while (j < this.selGridy) {
                            if (this.mouseX / this.aec.getScaleX() - this.selGridx + i >= 0 && this.mouseY / this.aec.getScaleY() - this.selGridy + j >= 0) {
                                this.paintgrid[this.mouseX / this.aec.getScaleX() + i - this.selGridx][this.mouseY / this.aec.getScaleY() + j - this.selGridy] = this.selectgrid[i][j];
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            } else if (this.selectMode && !this.moveMode) {
                int k = 0;
                int l = 0;
                this.mouseReleaseX = this.mouseX / this.aec.getScaleX();
                this.mouseReleaseY = this.mouseY / this.aec.getScaleY();
                this.selGridx = this.mouseReleaseX - this.startMouseX;
                this.selGridy = this.mouseReleaseY - this.startMouseY;
                if (this.selGridx > 0 && this.selGridy > 0) {
                    this.selectgrid = new int[this.selGridx][this.selGridy];
                    int i = this.startMouseX;
                    while (i < this.mouseReleaseX) {
                        int j = this.startMouseY;
                        while (j < this.mouseReleaseY) {
                            this.selectgrid[k][l] = this.paintgrid[i][j];
                            ++l;
                            ++j;
                        }
                        l = 0;
                        ++k;
                        ++i;
                    }
                    this.moveMode = true;
                }
                this.selectStarted = false;
            } else if (!(this.playback || this.selectMode || this.moveMode)) {
                if (this.mouseButton == 37) {
                    this.paint();
                } else if (this.mouseButton == 39) {
                    this.erase();
                }
            }
        }
    }

    public void mouseDragged() {
        block5: {
            block6: {
                block7: {
                    if (this.mouseY >= 400) break block5;
                    if (this.selectMode) break block6;
                    if (this.mouseButton != 37) break block7;
                    this.paint();
                    break block5;
                }
                if (this.mouseButton != 39) break block5;
                this.erase();
                break block5;
            }
            if (!this.selectStarted && !this.moveMode) {
                this.selectStarted = true;
                this.startMouseX = this.mouseX / this.aec.getScaleX();
                this.startMouseY = this.mouseY / this.aec.getScaleY();
            } else if (this.selectStarted) {
                int i = this.startMouseX;
                while (i < this.mouseX / this.aec.getScaleX()) {
                    int j = this.startMouseY;
                    while (j < this.mouseY / this.aec.getScaleY()) {
                        int temp = this.paintgrid[i][j];
                        this.fill(this.color(this.red(temp), this.green(temp) + 255.0f, this.blue(temp)));
                        this.rect(i * this.aec.getScaleX(), j * this.aec.getScaleY(), 1 * this.aec.getScaleX(), 1 * this.aec.getScaleY());
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void mouseClicked() {
    }

    public void keyPressed() {
        if (this.keyCode == 17) {
            this.selectMode = !this.selectMode;
            this.infotext.setText("Selectmode: " + this.selectMode);
            if (!this.selectMode) {
                this.moveMode = false;
            }
        }
        if (!this.playback) {
            this.infotext.setText("" + this.keyCode);
            if (this.key == 'i') {
                this.infotext.setText("IMPORT");
                this.importFromFile();
            }
            if (this.key == 'e') {
                this.infotext.setText("EDITMODE");
                if (this.editMode) {
                    this.cp5.get("Frame_Input").hide();
                    this.cp5.get("Submit").hide();
                } else {
                    this.cp5.get("Frame_Input").show();
                    this.cp5.get("Submit").show();
                }
                boolean bl = this.editMode = !this.editMode;
            }
            if (this.keyCode == 32 && !this.editMode) {
                this.flashTime = this.millis() + 1000;
                this.fill(255);
                this.rect(800.0f, 20.0f, 100.0f, 100.0f);
                this.infotext.setText("SAVEFRAME");
                this.saveFacadeFrame(this.cur_frame++);
                if (this.cur_frame % 25 == 0) {
                    this.infotext.setText("AUTOSAVE");
                    this.exportToFile();
                }
            }
            if (this.keyCode == 32 && this.editMode) {
                this.infotext.setText("UPDATE FRAME");
                this.insertFacadeFrame(PApplet.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).getText()));
                this.flashTime = this.millis() + 1000;
                this.fill(255);
                this.rect(800.0f, 20.0f, 100.0f, 100.0f);
            }
            if (this.keyCode == 10 && this.editMode) {
                this.infotext.setText("Read frame:" + ((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).getText());
                this.readFrame(PApplet.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).getText()));
            }
            if (this.key == 's') {
                this.infotext.setText("EXPORT PLEASE WAIT!");
                this.exportToFile();
                this.infotext.setText("FINISHED EXPORTING");
            }
        }
        if (this.key == 'p' && !this.selectMode && !this.editMode) {
            this.playback = !this.playback;
            this.infotext.setText("Playback: " + this.playback);
            this._frame = 0;
            this.triggerframetime = this.millis() + this.aniFramerate;
            if (!this.playback) {
                this.infotext.setText("PLAYBACK FINISHED");
                this.showFacadeFrame(this.animation.size() - 1);
            }
        }
    }

    public void importFromFile() {
        this.resetFrame();
        this.resetAnimation();
        this.infotext.setText(String.valueOf(this.animation.size() - 1) + " clear Framesize");
        this.pixelTable.clearRows();
        this.pixelTable = this.loadTable("animation.csv", "header");
        int rowcnt = 0;
        int frmcnt = 0;
        int[][] tmpgrid = new int[this.x][this.y];
        int _f = 0;
        for (TableRow newPixelRow : this.pixelTable.rows()) {
            if (_f != newPixelRow.getInt("f")) {
                this.animation.add(new frame(++frmcnt - 1, this.myClone(tmpgrid)));
            }
            _f = newPixelRow.getInt("f");
            int _x = newPixelRow.getInt("x");
            int _y = newPixelRow.getInt("y");
            int _c = this.color(newPixelRow.getInt("r"), newPixelRow.getInt("g"), newPixelRow.getInt("b"), newPixelRow.getInt("a"));
            if (_x >= 0) {
                tmpgrid[_x][_y] = _c;
            }
            ++rowcnt;
        }
        this.animation.add(new frame(++frmcnt - 1, this.myClone(tmpgrid)));
        this.infotext.setText(String.valueOf(rowcnt) + " Rows imported");
        this.infotext.setText("Framesize: " + this.animation.size());
        this.cur_frame = this.animation.size() - 1;
    }

    public void readFrame(int _frame) {
        if (this.animation.size() == 0) {
            this.importFromFile();
        }
        this.showFacadeFrame(_frame);
        this.infotext.setText("FRAME LOADED");
    }

    public void Submit(int value) {
        this.infotext.setText("Read frame:" + ((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).getText());
        this.readFrame(PApplet.parseInt((String)((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).getText()));
    }

    public void exportToFile() {
        TableRow newPixelRow = null;
        Boolean noChange = true;
        this.pixelTable.clearRows();
        frame f = null;
        frame prev_f = new frame(0, new int[this.x][this.y]);
        int z = 0;
        while (z < this.animation.size()) {
            f = this.animation.get(z);
            if (z > 0) {
                prev_f = this.animation.get(z - 1);
            }
            int i = 0;
            while (i < this.x) {
                int j = 0;
                while (j < this.y) {
                    if (f._framepaintgrid[i][j] != prev_f._framepaintgrid[i][j]) {
                        newPixelRow = this.pixelTable.addRow();
                        newPixelRow.setInt("f", f._f);
                        newPixelRow.setInt("x", i);
                        newPixelRow.setInt("y", j);
                        newPixelRow.setInt("r", PApplet.parseInt((float)this.red(f._framepaintgrid[i][j])));
                        newPixelRow.setInt("g", PApplet.parseInt((float)this.green(f._framepaintgrid[i][j])));
                        newPixelRow.setInt("b", PApplet.parseInt((float)this.blue(f._framepaintgrid[i][j])));
                        newPixelRow.setInt("a", PApplet.parseInt((float)this.alpha(f._framepaintgrid[i][j])));
                        noChange = false;
                    }
                    ++j;
                }
                ++i;
            }
            if (noChange.booleanValue() && z > 0) {
                f = this.animation.get(z - 1);
                newPixelRow = this.pixelTable.addRow();
                newPixelRow.setInt("f", f._f + 1);
                newPixelRow.setInt("x", -1);
                newPixelRow.setInt("y", -1);
                newPixelRow.setInt("r", -1);
                newPixelRow.setInt("g", -1);
                newPixelRow.setInt("b", -1);
                newPixelRow.setInt("a", -1);
            } else if (z == 0) {
                f = this.animation.get(0);
                newPixelRow = this.pixelTable.addRow();
                newPixelRow.setInt("f", 0);
                newPixelRow.setInt("x", 0);
                newPixelRow.setInt("y", 0);
                newPixelRow.setInt("r", 0);
                newPixelRow.setInt("g", 0);
                newPixelRow.setInt("b", 0);
                newPixelRow.setInt("a", 0);
            }
            noChange = true;
            ++z;
        }
        this.saveTable(this.pixelTable, "animation.csv", "csv");
        this.infotext.setText(String.valueOf(this.pixelTable.getRowCount()) + " rows exported");
        this.pixelTable.clearRows();
    }

    public void showFacadeFrame(int _frame) {
        if (_frame >= this.animation.size()) {
            _frame = this.animation.size() - 1;
        }
        this.resetFrame();
        this.paintgrid = this.myClone(this.animation.get((int)_frame)._framepaintgrid);
        this.infotext.setText("Show Frame: " + _frame);
    }

    public void insertFacadeFrame(int _frame) {
        this.animation.remove(_frame);
        this.animation.add(_frame, new frame(_frame, this.myClone(this.paintgrid)));
    }

    public int[][] myClone(int[][] from) {
        int[][] returnArr = new int[this.x][this.y];
        int i = 0;
        while (i < this.x) {
            int j = 0;
            while (j < this.y) {
                returnArr[i][j] = from[i][j];
                ++j;
            }
            ++i;
        }
        return returnArr;
    }

    public void saveFacadeFrame(int _cur_frame) {
        this.animation.add(new frame(_cur_frame, this.myClone(this.paintgrid)));
        this.infotext.setText("Frame: " + _cur_frame);
        this.infotext.setText("FRAME SAVED");
    }

    public void controlEvent(ControlEvent c) {
        if (c.isFrom((ControllerInterface)this.cw)) {
            this.brushcolor = ((ColorWheel)this.cp5.get(ColorWheel.class, "c")).getRGB();
            this.infotext.setText("New Color picked!");
        }
    }

    public void radioButton(int a) {
        AEC_SimpleRect_Drawer_09.println((int)a);
        switch (a) {
            case 1: {
                this.aniFramerate = 1000;
                break;
            }
            case 2: {
                this.aniFramerate = 200;
                break;
            }
            case 3: {
                this.aniFramerate = 67;
                break;
            }
            case 4: {
                this.aniFramerate = 40;
            }
        }
        this.infotext.setText("Framerate: " + this.aniFramerate);
    }

    public void brushsizeradiobutton(int a) {
        switch (a) {
            case 11: {
                this.brushsize = 1;
                break;
            }
            case 12: {
                this.brushsize = 2;
                break;
            }
            case 13: {
                this.brushsize = 4;
                break;
            }
            case 14: {
                this.brushsize = 8;
            }
        }
        this.infotext.setText("Brushsize: " + this.brushsize);
    }

    public void play(int theValue) {
        if (!this.starting && !this.editMode) {
            this.playback = !this.playback;
            this.infotext.setText("Playback: " + this.playback);
            this._frame = 0;
            this.triggerframetime = this.millis() + this.aniFramerate;
            if (!this.playback) {
                this.infotext.setText("PLAYBACK FINISHED");
                this.showFacadeFrame(this.animation.size() - 1);
            }
        }
    }

    public void export(int theValue) {
        if (!this.starting) {
            this.exportToFile();
        }
    }

    public void stamp(int theValue) {
        if (!this.starting) {
            this.selectMode = !this.selectMode;
            this.infotext.setText("Selectmode: " + this.selectMode);
            if (!this.selectMode) {
                this.moveMode = false;
            }
        }
    }

    public void moveObject() {
        if (this.mouseX < 1350 & this.mouseY < 225) {
            int i = 0;
            while (i < this.selGridx) {
                int j = 0;
                while (j < this.selGridy) {
                    int temp = this.selectgrid[i][j];
                    this.fill(this.color(this.red(temp), this.green(temp) + 255.0f, this.blue(temp)));
                    this.rect(this.mouseX / this.aec.getScaleX() + i - this.selGridx, this.mouseY / this.aec.getScaleY() + j - this.selGridy, 1.0f, 1.0f);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void edit(int theValue) {
        if (!this.starting) {
            this.infotext.setText("EDITMODE");
            if (this.editMode) {
                this.cp5.get("Frame_Input").hide();
                this.cp5.get("Submit").hide();
                ((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).clear();
            } else {
                this.cp5.get("Frame_Input").show();
                this.cp5.get("Submit").show();
                ((Textfield)this.cp5.get(Textfield.class, "Frame_Input")).setFocus(true);
            }
            this.editMode = !this.editMode;
        }
    }

    public void settings() {
        this.size(1200, 450);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AEC_SimpleRect_Drawer_09"};
        if (passedArgs != null) {
            PApplet.main((String[])AEC_SimpleRect_Drawer_09.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AEC {
        AECPlugin plugin = new AECPlugin();
        HouseDrawer house;

        public AEC() {
            this.house = new HouseDrawer(this.plugin);
        }

        public void init() {
            this.plugin.setFrameWidth(AEC_SimpleRect_Drawer_09.this.width);
            this.plugin.init();
            this.loadConfig();
        }

        public void loadConfig() {
            this.plugin.loadConfig();
        }

        public void beginDraw() {
            AEC_SimpleRect_Drawer_09.this.scale(2 * this.plugin.scale, this.plugin.scale);
        }

        public void endDraw() {
            AEC_SimpleRect_Drawer_09.this.resetMatrix();
            AEC_SimpleRect_Drawer_09.this.loadPixels();
            this.plugin.update(AEC_SimpleRect_Drawer_09.this.pixels);
        }

        public void drawSides() {
            this.house.draw();
        }

        public void keyPressed(int value) {
            this.plugin.keyPressed(value, AEC_SimpleRect_Drawer_09.this.keyCode);
            if (value == 105) {
                this.house.toggleIds();
            }
        }

        public void setActiveColor(Color c) {
            this.plugin.setActiveColor(c);
        }

        public void setInActiveColor(Color c) {
            this.plugin.setInActiveColor(c);
        }

        public int getScaleX() {
            return 2 * this.plugin.scale;
        }

        public int getScaleY() {
            return this.plugin.scale;
        }
    }

    class HouseDrawer {
        AECPlugin aec;
        int size = 10;
        PFont font;
        boolean showIds = false;

        public HouseDrawer(AECPlugin aec_) {
            this.aec = aec_;
            this.font = AEC_SimpleRect_Drawer_09.this.loadFont("LucidaConsole-8.vlw");
        }

        public void toggleIds() {
            this.showIds = !this.showIds;
        }

        public void draw() {
            AEC_SimpleRect_Drawer_09.this.resetMatrix();
            int i = 0;
            while (i < Building.SIDE.values().length) {
                Building.SIDE sideEnum = Building.SIDE.values()[i];
                Side side = this.aec.getSide(sideEnum);
                AEC_SimpleRect_Drawer_09.this.stroke(side.getColor().getRed(), side.getColor().getGreen(), side.getColor().getBlue(), side.getColor().getAlpha());
                AEC_SimpleRect_Drawer_09.this.noFill();
                this.drawSide(side);
                ++i;
            }
        }

        public void drawSide(Side s) {
            int[][] adr = s.getWindowAddress();
            int pWidth = s.getPixelWidth();
            int pHeight = s.getPixelHeight();
            int y = 0;
            while (y < adr.length) {
                int x = 0;
                while (x < adr[y].length) {
                    if (adr[y][x] > -1) {
                        int fx = (s.getX() + x * pWidth) * this.aec.scale;
                        int fy = (s.getY() + y * pHeight) * this.aec.scale;
                        AEC_SimpleRect_Drawer_09.this.rect(fx, fy, pWidth * this.aec.scale, pHeight * this.aec.scale);
                        if (this.showIds) {
                            AEC_SimpleRect_Drawer_09.this.textFont(this.font, 8.0f);
                            AEC_SimpleRect_Drawer_09.this.text("" + adr[y][x], fx + pWidth * this.aec.scale / 4, (float)fy + (float)(pHeight * this.aec.scale) * 0.9f);
                        }
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    class frame {
        int _f;
        int[][] _framepaintgrid;

        public frame() {
        }

        public frame(int f, int[][] framepaintgrid) {
            this._f = f;
            this._framepaintgrid = framepaintgrid;
        }
    }
}

