class Fish {

  float x, y, w, h, scaleFactor, direction, v, speed, attractionRadius, attractionForce;
  PImage img;
  String file;
  PGraphics pg;
  int sex, startTime, grownUp;
  
  int dir, step, maxStep; // für Pendelbewegung
  float jitter; // für Pendelbewegung 
  
  Fish(float x, float y, float h, float w, float direction, float v)
  {
    this.x = x;
    this.y = y;
    this.h = h;
    this.w = w;
    this.direction = direction;
    this.v = v;
  }
  
  Fish (float x, float y, float w, float h, float scaleFactor, float direction, float v, float attractionRadius, float attractionForce, int sex) 
  {
    startTime = millis();
    grownUp = 5000;    
    
    this.x = x;
    this.y = y;
    
    this.sex = sex;
    
    switch (this.sex)
    {
      case 0:
        file = "fish_male.png";
        break;
      case 1:
        file = "fish_female.png";
        break;
      case 2:
        file = "Whitewhale.png";
        break;
    }
    
    this.scaleFactor = scaleFactor;
    this.direction = direction;
    this.v = v;
    
    this.attractionRadius = attractionRadius;
    this.attractionForce = attractionForce;
    
    this.file = file;
 
    
    img = loadImage(file);
    this.w = (int)w;
    this.h = (int)h;
    pg = createGraphics((int)w, (int)h, JAVA2D);
    pg.image(img, 0, 0, w, h);
    
    // für Pendelbewegung
    this.dir = 1;
    this.step = 0;
    this.maxStep = 6;
    this.jitter = radians(0.5);
  }

  void display()
  {
   
    pushMatrix();
    
    translate(this.x, this.y);
    scale(this.scaleFactor);
    rotate(this.direction + this.step * this.jitter);

    translate(-this.w, -this.h/2);
    image(this.img, 0, 0, this.w, this.h);

    popMatrix();   

    // für Pendelbewegung
    if (abs(step) == maxStep) {
      dir *= -1;
    }
    step += dir;
  }

  void calculate()
  {

    this.x = this.x + this.v * cos(this.direction);
    this.y = this.y + this.v * sin(this.direction); 

    if (this.x > width + this.w * this.scaleFactor)
    {
      this.x = width + this.w * this.scaleFactor;
      this.direction = PI - this.direction;
      
    }
    else if (this.x < 0 - this.w * this.scaleFactor) {

      this.x = 0 - this.w * this.scaleFactor;
      this.direction = PI - direction;
      
    }
    else if (this.y < 0 - this.w * this.scaleFactor) 
    {
      this.y = 0 - this.h * this.scaleFactor;
      this.direction *= -1;
    }
    else if (this.y > height + this.w * this.scaleFactor) 
    {
      this.y = height + this.h * this.scaleFactor;
      this.direction *= -1;
    }
    
  }

  boolean collide (Fish f) 
  {
    float d = dist(this.x, this.y, f.x, f.y);
  
    //if (((this.w * this.scaleFactor) / 2 + (f.w * this.scaleFactor) / 2) > d)
    if (((this.w) / 2 + (f.w) / 2) > d)
    { 
      return true;
    } 
    else 
    {
      return false;
    }
  }
  
  void collideAction()
  {
    this.w += 1;
    this.h += 1;
    
    this.v = this.v - 0.1;
  }

  boolean attractFish (Fish f) 
  {
    
    float d = dist(this.x, this.y, f.x, f.y);
    
    if (d < f.attractionRadius) // radius 
    {
      float dx = f.x - this.x;
      float dy = f.y - this.y;
      
      float vx = this.v * cos(this.direction);
      float vy = this.v * sin(this.direction);
      

      if (this.w * this.scaleFactor > f.w * f.scaleFactor)
      {
        vx += (dx/d) * f.attractionForce;  
        vy += (dy/d) * f.attractionForce;  
      }
      else if (this.w * this.scaleFactor < f.w * f.scaleFactor)
      {
        vx += (dx/d) * f.attractionForce * -5;  
        vy += (dy/d) * f.attractionForce * -5;       
      }
      
      this.direction = atan2(vy, vx);
      // v = dist(0, 0, vx, vy);
    }
    
    return false;
  }

  boolean attractKoeder (Koeder k) 
  {
    
    float d = dist(this.x, this.y, k.x, k.y);
    
    if (d < this.w/2) 
    {
      koederList.remove(k);
      return true;
    } 
    else if (d < k.radius) 
    {
      float dx = k.x - this.x;
      float dy = k.y - this.y;
      float vx = this.v * cos(this.direction);
      float vy = this.v * sin(this.direction);
      vx += (dx/d) * k.force;  // *(1-d/k.radius)
      vy += (dy/d) * k.force;  // *(1-d/k.radius)
      this.direction = atan2(vy, vx);
      // v = dist(0, 0, vx, vy);
    }
    
    return false;
  }
  
  public boolean isGrownUp()
  {
    //opacity = round(map(millis()-startTime, 0, 5000, 255, 0));
    
    if ((millis() - startTime) >= grownUp)
    {
      startTime = millis();
      return true;
    }
    else
    {
      return false;
    }
  }

}

