import TUIO.*;
TuioProcessing tuioClient;

ArrayList fishList, koederList, bubbles, sex;
Fish fish1, fish2, fish;
Koeder koeder;
int opacity;

boolean isReset, whiteWhale;

void setup ()
{
  size(1280, 768);
  smooth();
  noCursor();

  opacity = 0;

  tuioClient = new TuioProcessing(this);

  fishList = new ArrayList();
  koederList = new ArrayList();

  //  fish = new Fish(width/2, height/2, "fish.png", 300, 150, 0.5, -PI/4, 2);

  for (int i = 0; i < 40; i++) 
  {
    //   Fish (float x, float y, float w, float h, float scaleFactor, float direction, float v, float attractionRadius, float attractionForce, int sex) 
    fishList.add (new Fish(random(20, width), random(20, height), 8, 2, random (1, 7), random(0.1, 3), random (1.5, 2.5), 50, 0.05, round(random(0, 1))));
  }

  bubbles = new ArrayList();
  
  isReset = false;
  whiteWhale = false;
}

void draw ()
{
  background(100, 190, 255);
  
  if (opacity <= 255)
  {
    tint(255, opacity);
    opacity = opacity + 51;
  }
  
  if (isReset)
  {
    Fish bigWhiteOne = (Fish)fishList.get(0);
    
    if ((bigWhiteOne.x >= width + bigWhiteOne.w) || (bigWhiteOne.x <= 0 - bigWhiteOne.w))
    {
      println("DO RESET");
      reset();
    }
  }
  
  // Fischkollisionen ermitteln
  for (int i = 0; i < fishList.size() - 1; i++) {
    fish1 = (Fish)fishList.get(i);
    for (int j = i + 1; j < fishList.size(); j++) {
      fish2 = (Fish)fishList.get(j);

      // Fish + Fish attraction

      fish1.attractFish(fish2);
      fish2.attractFish(fish1);

      if (fish1.sex == 2)
      {
        bubbles.add(new Bubble(fish2.x, fish1.y, color(255), 50, 5));
        fishList.remove(fish2);
      }
      else if (fish2.sex == 2)
      {
        bubbles.add(new Bubble(fish1.x, fish1.y, color(255), 50, 5));
        fishList.remove(fish1);
      }
      else if (fish1.collide(fish2) && fish1.isGrownUp() && fish2.isGrownUp()) // Fish kollision 
      {
        // hier steht die Aktion, wenn sich die Fische berühren

        // Babys
        if (fish1.sex != fish2.sex)
        {
          bubbles.add(new Bubble(fish1.x, fish1.y, color(255, 255, 1), 50, 5));         

          fishList.add (new Fish(fish1.x, fish1.y, 8, 2, random (2, 4), random(0.1, 3), random (1.5, 2.5), 50, 0.1, round(random(0, 1))));

          break;
        }
        else if (fish1.sex == fish2.sex)
          // Fressen
          bubbles.add(new Bubble(fish1.x, fish1.y, color(255), 50, 5));

        if (fish1.w  * fish1.scaleFactor >= fish2.w * fish2.scaleFactor) 
        {
          fish1.collideAction();

          fishList.remove(fish2);
        } 
        else if (fish2.w * fish2.scaleFactor >= fish1.w * fish1.scaleFactor) 
        {
          fish2.collideAction();

          fishList.remove(fish1);
        }
      }
    }
  }


  // Koederanziehung berechnen
  for (int i = 0; i < fishList.size(); i++) 
  {
    fish = (Fish)fishList.get(i);    

    for (int j=0;j<koederList.size();j++) 
    {
      koeder = (Koeder)koederList.get(j); 

      if (fish.attractKoeder(koeder))
      {                 
        fish.w += 1;
        fish.h += 1;

        fish.v = fish.v - 0.1;
      }

      // Koeder abgeflaufen?
      if (koeder.isExpired())
      {       
        koederList.remove(j);
      }
    }
  }

  // Zeichen der Elemente
  for (int k=0; k < koederList.size(); k++) 
  {
    koeder = (Koeder)koederList.get(k); 
    koeder.display();
  }

  for (int k=0;k<fishList.size();k++) 
  {
    fish = (Fish)fishList.get(k); 
    fish.calculate();

    fish.display();
  }

  // Bubble
  Bubble b;
  for (int i = bubbles.size()-1; i >= 0; i--)
  { 
    b = (Bubble) bubbles.get(i);
    if (!b.isFinished()) 
    {
      b.displayBubble();
    } 
    else 
    {
      bubbles.remove(i);
    }
  }
}

void reset()
{
  fishList = new ArrayList();
  opacity = 0;

  Bubble birthBubble = (Bubble)bubbles.get(0);
  
  for (int i = 0; i < 20; i++) 
  {

    //   Fish (float x, float y, float w, float h, float scaleFactor, float direction, float v, float attractionRadius, float attractionForce, int sex) 
    fishList.add (new Fish(birthBubble.x + i, birthBubble.y + i, 8, 2, random (1, 7), random(0.1, 3), random (1.5, 2.5), 50, 0.05, round(random(0, 1))));
  }
  
  isReset = false;
  whiteWhale = false;
}

void addTuioCursor(TuioCursor tcur) 
{
  Koeder k;

  float d;

  boolean addKoeder = true;

  // reset - Bluewhale attacks

  if (whiteWhale)
  {
    isReset = true;
    println("isReset");
  }

  if (tcur.getCursorID() == 9)
  {
    fishList.add (new Fish(0, height/2, 1870, 705, 1, 0, 80, 100, 2, 2));
    whiteWhale = true;
    
    println("whiteWhale");
  }


  for (int i=0; i<koederList.size(); i++)
  {
    k = (Koeder)koederList.get(i);

    if (k.radius/10 > dist(k.x, k.y, tcur.getScreenX(width), tcur.getScreenY(height)))
    {
      addKoeder = false;
      break;
    }
  }

  if (addKoeder && whiteWhale == false)
  {
    koederList.add(new Koeder(tcur, tcur.getScreenX(width), tcur.getScreenY(height), 500, 0.6));
    bubbles.add(new Bubble(tcur.getScreenX(width), tcur.getScreenY(height), color(100, 178, 255), 100, 5));
    bubbles.add(new Bubble(tcur.getScreenX(width), tcur.getScreenY(height), color(100, 182, 255), 100, 2));
  }
  
  if (whiteWhale)
  {
    bubbles.add(new Bubble(tcur.getScreenX(width), tcur.getScreenY(height), color(100, 178, 255), 100, 5));
  }

  // koederList.add(new Koeder(tcur, tcur.getScreenX(width), tcur.getScreenY(height), 600  - ((koederList.size() + 1) * 10), 0.6 - ((koederList.size() + 1) * 0.05)));
}

void updateTuioCursor(TuioCursor tcur) 
{
} 

void removeTuioCursor(TuioCursor tcur)
{
}

void refresh(TuioTime bundleTime)
{
}

void addTuioObject(TuioObject tobj)
{
}

void removeTuioObject(TuioObject tobj)
{
}

void updateTuioCursor(TuioObject tobj)
{
}

void updateTuioObject(TuioObject tobj)
{
}

void mousePressed()
{
  
}

